/*
 * Decompiled with CFR 0.152.
 */
package apoc.bolt;

import apoc.Description;
import apoc.bolt.BoltConfig;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.MapUtil;
import apoc.util.UriResolver;
import apoc.util.Util;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.SummaryCounters;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Bolt {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.bolt.load(url-or-key, statement, params, config) - access to other databases via bolt for read/write")
    public Stream<RowResult> load(@Name(value="url") String url, @Name(value="statement") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        if (params == null) {
            params = Collections.emptyMap();
        }
        BoltConfig boltConfig = new BoltConfig(config);
        Config driverConfig = this.toDriverConfig(config.getOrDefault("driverConfig", MapUtil.map(new Object[0])));
        UriResolver uri = new UriResolver(url, "bolt");
        uri.initialize();
        try {
            Driver driver = GraphDatabase.driver((URI)uri.getConfiguredUri(), (AuthToken)uri.getToken(), (Config)driverConfig);
            Session session = driver.session();
            Stream<RowResult> result = boltConfig.isAddStatistics() ? Stream.of(new RowResult(this.toMap(this.runStatement(statement, session, params, boltConfig).summary().counters()))) : this.getRowResultStream(session, params, statement, boltConfig);
            return (Stream)result.onClose(() -> {
                session.close();
                driver.close();
            });
        }
        catch (Exception e) {
            throw new RuntimeException("It's not possible to create a connection due to: " + e.getMessage());
        }
    }

    @Procedure
    @Description(value="apoc.bolt.execute(url-or-key, statement, params, config) - access to other databases via bolt for read")
    public Stream<RowResult> execute(@Name(value="url") String url, @Name(value="statement") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        HashMap<String, Object> configuration = new HashMap<String, Object>(config);
        configuration.put("readOnly", false);
        return this.load(url, statement, params, configuration);
    }

    private StatementResult runStatement(@Name(value="statement") String statement, Session session, Map<String, Object> finalParams, BoltConfig boltConfig) {
        return boltConfig.isReadOnly() ? (StatementResult)session.readTransaction(tx -> tx.run(statement, finalParams)) : (StatementResult)session.writeTransaction(tx -> tx.run(statement, finalParams));
    }

    private Stream<RowResult> getRowResultStream(Session session, Map<String, Object> params, String statement, BoltConfig boltConfig) {
        ConcurrentHashMap nodesCache = new ConcurrentHashMap();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.runStatement(statement, session, params, boltConfig), 0), true).map(record -> new RowResult(record.asMap(value -> this.convert(session, value, boltConfig, nodesCache))));
    }

    private Object convert(Session session, Object entity, BoltConfig boltConfig, Map<Long, Node> nodeCache) {
        if (entity instanceof Value) {
            return this.convert(session, ((Value)entity).asObject(), boltConfig, nodeCache);
        }
        if (entity instanceof org.neo4j.driver.v1.types.Node) {
            return this.toNode(entity, boltConfig, nodeCache);
        }
        if (entity instanceof Relationship) {
            return this.toRelationship(session, entity, boltConfig, nodeCache);
        }
        if (entity instanceof Path) {
            return this.toPath(session, entity, boltConfig, nodeCache);
        }
        if (entity instanceof Collection) {
            return this.toCollection(session, (Collection)entity, boltConfig, nodeCache);
        }
        if (entity instanceof Map) {
            return this.toMap(session, (Map)entity, boltConfig, nodeCache);
        }
        return entity;
    }

    private Object toMap(Session session, Map<String, Object> entity, BoltConfig boltConfig, Map<Long, Node> nodeCache) {
        return entity.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), this.convert(session, entry.getValue(), boltConfig, nodeCache))).collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue()));
    }

    private Object toCollection(Session session, Collection entity, BoltConfig boltConfig, Map<Long, Node> nodeCache) {
        return entity.stream().map(elem -> this.convert(session, elem, boltConfig, nodeCache)).collect(Collectors.toList());
    }

    private Object toNode(Object value, BoltConfig boltConfig, Map<Long, Node> nodesCache) {
        org.neo4j.driver.v1.types.Node node;
        if (value instanceof Value) {
            node = ((InternalEntity)value).asValue().asNode();
        } else if (value instanceof org.neo4j.driver.v1.types.Node) {
            node = (org.neo4j.driver.v1.types.Node)value;
        } else {
            throw this.getUnsupportedConversionException(value);
        }
        if (boltConfig.isVirtual()) {
            Label[] labels = this.getLabelsAsArray(node);
            return nodesCache.computeIfAbsent(node.id(), id -> new VirtualNode((long)id, labels, node.asMap(), this.db));
        }
        return Util.map("entityType", "NODE", "labels", node.labels(), "id", node.id(), "properties", node.asMap());
    }

    private Object toRelationship(Session session, Object value, BoltConfig boltConfig, Map<Long, Node> nodesCache) {
        Relationship relationship;
        if (value instanceof Value) {
            relationship = ((InternalEntity)value).asValue().asRelationship();
        } else if (value instanceof Relationship) {
            relationship = (Relationship)value;
        } else {
            throw this.getUnsupportedConversionException(value);
        }
        if (boltConfig.isVirtual()) {
            Node end;
            Node start;
            if (boltConfig.isWithRelationshipNodeProperties()) {
                Function<Long, Node> retrieveNode = id -> {
                    org.neo4j.driver.v1.types.Node node = ((StatementResult)session.readTransaction(tx -> tx.run("MATCH (n) WHERE id(n) = $id RETURN n", Collections.singletonMap("id", id)))).single().get("n").asNode();
                    Label[] labels = this.getLabelsAsArray(node);
                    return new VirtualNode((long)id, labels, node.asMap(), this.db);
                };
                start = nodesCache.computeIfAbsent(relationship.startNodeId(), retrieveNode);
                end = nodesCache.computeIfAbsent(relationship.endNodeId(), retrieveNode);
            } else {
                start = nodesCache.getOrDefault(relationship.startNodeId(), new VirtualNode(relationship.startNodeId(), this.db));
                end = nodesCache.getOrDefault(relationship.startNodeId(), new VirtualNode(relationship.endNodeId(), this.db));
            }
            return new VirtualRelationship(relationship.id(), start, end, RelationshipType.withName((String)relationship.type()), relationship.asMap());
        }
        return Util.map("entityType", "RELATIONSHIP", "type", relationship.type(), "id", relationship.id(), "start", relationship.startNodeId(), "end", relationship.endNodeId(), "properties", relationship.asMap());
    }

    private ClassCastException getUnsupportedConversionException(Object value) {
        return new ClassCastException("Conversion from class " + value.getClass().getName() + " not supported");
    }

    private Label[] getLabelsAsArray(org.neo4j.driver.v1.types.Node node) {
        return StreamSupport.stream(node.labels().spliterator(), false).map(Label::label).collect(Collectors.toList()).toArray(new Label[0]);
    }

    private Object toPath(Session session, Object value, BoltConfig boltConfig, Map<Long, Node> nodesCache) {
        Path path;
        LinkedList entityList = new LinkedList();
        if (value instanceof Value) {
            path = ((InternalEntity)value).asValue().asPath();
        } else if (value instanceof Path) {
            path = (Path)value;
        } else {
            throw this.getUnsupportedConversionException(value);
        }
        path.forEach(p -> {
            entityList.add(this.toNode(p.start(), boltConfig, nodesCache));
            entityList.add(this.toRelationship(session, p.relationship(), boltConfig, nodesCache));
            entityList.add(this.toNode(p.end(), boltConfig, nodesCache));
        });
        return entityList;
    }

    private Map<String, Object> toMap(SummaryCounters resultSummary) {
        return MapUtil.map("nodesCreated", resultSummary.nodesCreated(), "nodesDeleted", resultSummary.nodesDeleted(), "labelsAdded", resultSummary.labelsAdded(), "labelsRemoved", resultSummary.labelsRemoved(), "relationshipsCreated", resultSummary.relationshipsCreated(), "relationshipsDeleted", resultSummary.relationshipsDeleted(), "propertiesSet", resultSummary.propertiesSet(), "constraintsAdded", resultSummary.constraintsAdded(), "constraintsRemoved", resultSummary.constraintsRemoved(), "indexesAdded", resultSummary.indexesAdded(), "indexesRemoved", resultSummary.indexesRemoved());
    }

    private Config toDriverConfig(Object driverConfig) {
        Map driverConfMap = (Map)driverConfig;
        String logging = driverConfMap.getOrDefault("logging", "INFO");
        boolean encryption = driverConfMap.getOrDefault("encryption", true);
        boolean logLeakedSessions = driverConfMap.getOrDefault("logLeakedSessions", true);
        Long maxIdleConnectionPoolSize = driverConfMap.getOrDefault("maxIdleConnectionPoolSize", 10L);
        Long idleTimeBeforeConnectionTest = driverConfMap.getOrDefault("idleTimeBeforeConnectionTest", -1L);
        String trustStrategy = driverConfMap.getOrDefault("trustStrategy", "TRUST_ALL_CERTIFICATES");
        Long routingFailureLimit = driverConfMap.getOrDefault("routingFailureLimit", 1L);
        Long routingRetryDelayMillis = driverConfMap.getOrDefault("routingRetryDelayMillis", 5000L);
        Long connectionTimeoutMillis = driverConfMap.getOrDefault("connectionTimeoutMillis", 5000L);
        Long maxRetryTimeMs = driverConfMap.getOrDefault("maxRetryTimeMs", 30000L);
        Config.ConfigBuilder config = Config.build();
        config.withLogging((Logging)new JULogging(Level.parse(logging)));
        if (!encryption) {
            config.withoutEncryption();
        }
        config.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
        if (!logLeakedSessions) {
            config.withoutEncryption();
        }
        config.withMaxIdleSessions(maxIdleConnectionPoolSize.intValue());
        config.withConnectionLivenessCheckTimeout(idleTimeBeforeConnectionTest.longValue(), TimeUnit.MILLISECONDS);
        config.withRoutingFailureLimit(routingFailureLimit.intValue());
        config.withConnectionTimeout(connectionTimeoutMillis.longValue(), TimeUnit.MILLISECONDS);
        config.withRoutingRetryDelay(routingRetryDelayMillis.longValue(), TimeUnit.MILLISECONDS);
        config.withMaxTransactionRetryTime(maxRetryTimeMs.longValue(), TimeUnit.MILLISECONDS);
        if (trustStrategy.equals("TRUST_ALL_CERTIFICATES")) {
            config.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
        } else if (trustStrategy.equals("TRUST_SYSTEM_CA_SIGNED_CERTIFICATES")) {
            config.withTrustStrategy(Config.TrustStrategy.trustSystemCertificates());
        } else {
            File file = new File(trustStrategy);
            config.withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File)file));
        }
        return config.toConfig();
    }
}

