/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.pagerank;

import apoc.algo.algorithms.AlgoUtils;
import apoc.algo.algorithms.AlgorithmInterface;
import apoc.algo.pagerank.PageRank;
import apoc.algo.pagerank.PageRankUtils;
import apoc.stats.DegreeUtil;
import apoc.util.kernel.MultiThreadedGlobalGraphOperations;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.TerminationGuard;

public class PageRankArrayStorageParallelSPI
implements PageRank,
AlgorithmInterface {
    public static final int ONE_MINUS_ALPHA_INT = PageRankUtils.toInt(0.15000000000000002);
    private final GraphDatabaseAPI db;
    private final TerminationGuard guard;
    private final int nodeCount;
    private final ExecutorService pool;
    private final int relCount;
    private final DependencyResolver dependencyResolver;
    private final KernelTransaction ktx;
    private AtomicIntegerArray dst;
    private PageRank.PageRankStatistics stats = new PageRank.PageRankStatistics();

    public PageRankArrayStorageParallelSPI(GraphDatabaseService db, KernelTransaction ktx, TerminationGuard guard, ExecutorService pool) {
        this.guard = guard;
        this.pool = pool;
        this.db = (GraphDatabaseAPI)db;
        this.ktx = ktx;
        this.dependencyResolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        this.nodeCount = (int)MultiThreadedGlobalGraphOperations.getHighestIdInUseForStore(this.dependencyResolver, MultiThreadedGlobalGraphOperations.GlobalOperationsTypes.NODES);
        this.relCount = (int)MultiThreadedGlobalGraphOperations.getHighestIdInUseForStore(this.dependencyResolver, MultiThreadedGlobalGraphOperations.GlobalOperationsTypes.RELATIONSHIPS);
    }

    @Override
    public void compute(int iterations, RelationshipType ... relationshipTypes) {
        this.stats.iterations = iterations;
        long start = System.currentTimeMillis();
        int[] src = new int[this.nodeCount];
        this.dst = new AtomicIntegerArray(this.nodeCount);
        int[] degrees = this.computeDegrees();
        this.stats.readNodeMillis = System.currentTimeMillis() - start;
        this.stats.nodes = this.nodeCount;
        start = System.currentTimeMillis();
        int[] relationshipTypesIds = this.fetchRelationshipTypeIds(relationshipTypes);
        this.stats.readRelationshipMillis = System.currentTimeMillis() - start;
        this.stats.relationships = this.relCount;
        start = System.currentTimeMillis();
        for (int iteration = 0; iteration < iterations; ++iteration) {
            this.startIteration(src, this.dst, degrees);
            MultiThreadedGlobalGraphOperations.forAllRelationships(this.db, this.pool, 100000, (ktx, relationshipScanCursor) -> {
                if (relationshipTypes.length == 0 || this.contains(relationshipTypesIds, relationshipScanCursor.type())) {
                    int endNode = (int)relationshipScanCursor.targetNodeReference();
                    int startNode = (int)relationshipScanCursor.sourceNodeReference();
                    this.dst.addAndGet(endNode, src[startNode]);
                }
            });
        }
        this.stats.computeMillis = System.currentTimeMillis() - start;
    }

    private int[] fetchRelationshipTypeIds(RelationshipType[] relationshipTypes) {
        int[] result = new int[relationshipTypes.length];
        TokenRead tokenRead = this.ktx.tokenRead();
        for (int i = 0; i < relationshipTypes.length; ++i) {
            result[i] = tokenRead.relationshipType(relationshipTypes[i].name());
        }
        return result;
    }

    private boolean contains(int[] relationshipTypes, int type) {
        for (int i = 0; i < relationshipTypes.length; ++i) {
            if (relationshipTypes[i] != type) continue;
            return true;
        }
        return false;
    }

    private void startIteration(int[] src, AtomicIntegerArray dst, int[] degrees) {
        for (int node = 0; node < this.nodeCount; ++node) {
            if (degrees[node] == -1) continue;
            src[node] = PageRankUtils.toInt(0.85 * PageRankUtils.toFloat(dst.getAndSet(node, ONE_MINUS_ALPHA_INT)) / (double)degrees[node]);
        }
    }

    private int[] computeDegrees() {
        int[] degree = new int[this.nodeCount];
        Arrays.fill(degree, -1);
        MultiThreadedGlobalGraphOperations.forAllNodes(this.db, this.pool, 100000, (ktx, nodeCursor) -> {
            degree[(int)nodeCursor.nodeReference()] = DegreeUtil.degree(nodeCursor, ktx.cursors(), -1, Direction.OUTGOING);
        });
        return degree;
    }

    @Override
    public double getResult(long node) {
        return this.dst != null ? PageRankUtils.toFloat(this.dst.get((int)node)) : 0.0;
    }

    @Override
    public long numberOfNodes() {
        return this.nodeCount;
    }

    @Override
    public String getPropertyName() {
        return "pagerank";
    }

    @Override
    public PageRank.PageRankStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public long getMappedNode(int algoId) {
        return algoId;
    }

    public void writeResultsToDB() {
        this.stats.write = true;
        long before = System.currentTimeMillis();
        AlgoUtils.writeBackResults(this.pool, this.db, this, 100100, this.guard);
        this.stats.write = true;
        this.stats.writeMillis = System.currentTimeMillis() - before;
        this.stats.property = this.getPropertyName();
    }
}

