/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import java.util.List;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Similarity {
    @Context
    public GraphDatabaseService db;

    @UserFunction
    @Description(value="apoc.algo.cosineSimilarity([vector1], [vector2]) given two collection vectors, calculate cosine similarity")
    public double cosineSimilarity(@Name(value="vector1") List<Number> vector1, @Name(value="vector2") List<Number> vector2) {
        if (vector1.size() != vector2.size() || vector1.size() == 0) {
            throw new RuntimeException("Vectors must be non-empty and of the same size");
        }
        double dotProduct = 0.0;
        double xLength = 0.0;
        double yLength = 0.0;
        for (int i = 0; i < vector1.size(); ++i) {
            double weight1 = vector1.get(i).doubleValue();
            double weight2 = vector2.get(i).doubleValue();
            dotProduct += weight1 * weight2;
            xLength += weight1 * weight1;
            yLength += weight2 * weight2;
        }
        xLength = Math.sqrt(xLength);
        yLength = Math.sqrt(yLength);
        return dotProduct / (xLength * yLength);
    }

    @UserFunction
    @Description(value="apoc.algo.euclideanDistance([vector1], [vector2]) given two collection vectors, calculate the euclidean distance (square root of the sum of the squared differences)")
    public double euclideanDistance(@Name(value="vector1") List<Number> vector1, @Name(value="vector2") List<Number> vector2) {
        if (vector1.size() != vector2.size() || vector1.size() == 0) {
            throw new RuntimeException("Vectors must be non-empty and of the same size");
        }
        double distance = 0.0;
        for (int i = 0; i < vector1.size(); ++i) {
            double sqOfDiff = vector1.get(i).doubleValue() - vector2.get(i).doubleValue();
            sqOfDiff *= sqOfDiff;
            distance += sqOfDiff;
        }
        distance = Math.sqrt(distance);
        return distance;
    }

    @UserFunction
    @Description(value="apoc.algo.euclideanSimilarity([vector1], [vector2]) given two collection vectors, calculate similarity based on euclidean distance")
    public double euclideanSimilarity(@Name(value="vector1") List<Number> vector1, @Name(value="vector2") List<Number> vector2) {
        return 1.0 / (1.0 + this.euclideanDistance(vector1, vector2));
    }
}

