/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.Pools;
import apoc.algo.algorithms.AlgoUtils;
import apoc.algo.pagerank.PageRank;
import apoc.algo.pagerank.PageRankArrayStorageParallelCypher;
import apoc.algo.pagerank.PageRankArrayStorageParallelSPI;
import apoc.result.NodeScore;
import apoc.util.Util;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class PageRank {
    private static final String SETTING_PAGE_RANK_ITERATIONS = "iterations";
    private static final String SETTING_PAGE_RANK_TYPES = "types";
    static final ExecutorService pool = Pools.DEFAULT;
    static final Long DEFAULT_PAGE_RANK_ITERATIONS = 20L;
    @Context
    public GraphDatabaseAPI db;
    @Context
    public TerminationGuard guard;
    @Context
    public KernelTransaction ktx;
    @Context
    public Log log;

    @Deprecated
    @Procedure(value="apoc.algo.pageRank")
    @Description(value="CALL apoc.algo.pageRank(nodes) YIELD node, score - calculates page rank for given nodes")
    public Stream<NodeScore> pageRank(@Name(value="nodes") List<Node> nodes) {
        return this.innerPageRank(DEFAULT_PAGE_RANK_ITERATIONS, nodes, new RelationshipType[0]);
    }

    @Deprecated
    @Procedure(value="apoc.algo.pageRankWithConfig")
    @Description(value="CALL apoc.algo.pageRankWithConfig(nodes,{iterations:_,types:_}) YIELD node, score, info - calculates page rank for given nodes")
    public Stream<NodeScore> pageRankWithConfig(@Name(value="nodes") List<Node> nodes, @Name(value="config") Map<String, Object> config) {
        return this.innerPageRank((Long)config.getOrDefault(SETTING_PAGE_RANK_ITERATIONS, DEFAULT_PAGE_RANK_ITERATIONS), nodes, Util.typesAndDirectionsToTypesArray((String)config.getOrDefault(SETTING_PAGE_RANK_TYPES, "")));
    }

    @Deprecated
    @Procedure(value="apoc.algo.pageRankStats", mode=Mode.WRITE)
    @Description(value="CALL apoc.algo.pageRankStats({iterations:_,types:_,write:true,...}) YIELD nodeCount - calculates page rank on graph  for given nodes and potentially writes back")
    public Stream<PageRank.PageRankStatistics> pageRankStats(@Name(value="config") Map<String, Object> config) {
        Long iterations = (Long)config.getOrDefault(SETTING_PAGE_RANK_ITERATIONS, DEFAULT_PAGE_RANK_ITERATIONS);
        RelationshipType[] types = Util.typesAndDirectionsToTypesArray((String)config.getOrDefault(SETTING_PAGE_RANK_TYPES, ""));
        return this.innerPageRankStats(iterations.intValue(), config, types);
    }

    @Deprecated
    @Procedure(value="apoc.algo.pageRankWithCypher", mode=Mode.WRITE)
    @Description(value="CALL apoc.algo.pageRankWithCypher({iterations,node_cypher,rel_cypher,write,property,numCpu}) - calculates page rank based on cypher input")
    public Stream<PageRank.PageRankStatistics> pageRankWithCypher(@Name(value="config") Map<String, Object> config) {
        Long iterations = (Long)config.getOrDefault(SETTING_PAGE_RANK_ITERATIONS, DEFAULT_PAGE_RANK_ITERATIONS);
        String nodeCypher = AlgoUtils.getCypher(config, "node_cypher", "MATCH (s) RETURN id(s) as id");
        String relCypher = AlgoUtils.getCypher(config, "rel_cypher", "MATCH (s)-[r]->(t) RETURN id(s) as source, id(t) as target, 1 as weight");
        boolean shouldWrite = (Boolean)config.getOrDefault("write", false);
        Number weight = (Number)config.get("weight");
        Number batchSize = (Number)config.get("batchSize");
        int concurrency = ((Number)config.getOrDefault("concurrency", Pools.getNoThreadsInDefaultPool())).intValue();
        String property = (String)config.getOrDefault("property", "pagerank");
        long beforeReading = System.currentTimeMillis();
        this.log.info("Pagerank: Reading data into local ds");
        PageRankArrayStorageParallelCypher pageRank = new PageRankArrayStorageParallelCypher(this.db, this.guard, pool, this.log);
        boolean success = pageRank.readNodeAndRelCypherData(relCypher, nodeCypher, weight, batchSize, concurrency);
        if (!success) {
            String errorMsg = "Failure while reading cypher queries. Make sure the results are ordered.";
            this.log.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        long afterReading = System.currentTimeMillis();
        this.log.info("Pagerank: Graph stored in local ds in " + (afterReading - beforeReading) + " milliseconds");
        this.log.info("Pagerank: Number of nodes: " + pageRank.numberOfNodes());
        this.log.info("Pagerank: Number of relationships: " + pageRank.numberOfRels());
        pageRank.compute(iterations.intValue(), new RelationshipType[0]);
        long afterComputation = System.currentTimeMillis();
        this.log.info("Pagerank: Computations took " + (afterComputation - afterReading) + " milliseconds");
        if (shouldWrite) {
            pageRank.writeResultsToDB(property);
            long afterWrite = System.currentTimeMillis();
            this.log.info("Pagerank: Writeback took " + (afterWrite - afterComputation) + " milliseconds");
        }
        return Stream.of(pageRank.getStatistics());
    }

    private Stream<NodeScore> innerPageRank(Long iterations, List<Node> nodes, RelationshipType ... types) {
        try {
            PageRankArrayStorageParallelSPI pageRank = new PageRankArrayStorageParallelSPI((GraphDatabaseService)this.db, this.ktx, this.guard, pool);
            pageRank.compute(iterations.intValue(), types);
            return nodes.stream().map(node -> new NodeScore((Node)node, pageRank.getResult(node.getId())));
        }
        catch (Exception e) {
            String errMsg = "Error encountered while calculating page rank";
            this.log.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
    }

    private Stream<PageRank.PageRankStatistics> innerPageRankStats(int iterations, Map<String, Object> config, RelationshipType ... types) {
        try {
            PageRankArrayStorageParallelSPI pageRank = new PageRankArrayStorageParallelSPI((GraphDatabaseService)this.db, this.ktx, this.guard, pool);
            pageRank.compute(iterations, types);
            if (((Boolean)config.getOrDefault("write", false)).booleanValue()) {
                pageRank.writeResultsToDB();
            }
            return Stream.of(pageRank.getStatistics());
        }
        catch (Exception e) {
            String errMsg = "Error encountered while calculating page rank";
            this.log.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
    }
}

