/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramUtil;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class Statistics {
    @UserAggregationFunction(value="apoc.agg.statistics")
    @Description(value="apoc.agg.statistics(value,[percentiles = 0.5,0.75,0.9,0.95,0.99]) - returns numeric statistics (percentiles, min,minNonZero,max,total,mean,stdev) for values")
    public StatisticsFunction statistics() {
        return new StatisticsFunction();
    }

    public static class StatisticsFunction {
        private Histogram values = new Histogram(3);
        private DoubleHistogram doubles;
        private List<Double> percentiles = Arrays.asList(0.5, 0.75, 0.9, 0.95, 0.9, 0.99);
        private Number minValue;
        private Number maxValue;

        @UserAggregationUpdate
        public void aggregate(@Name(value="value") Number value, @Name(value="percentiles", defaultValue="[0.5,0.75,0.9,0.95,0.99]") List<Double> percentiles) {
            if (value != null) {
                if (this.doubles != null) {
                    this.doubles.recordValue(value.doubleValue());
                } else if (value instanceof Double || value instanceof Float) {
                    this.doubles = HistogramUtil.toDoubleHistogram(this.values, 5);
                    this.doubles.recordValue(value.doubleValue());
                    this.values = null;
                } else {
                    this.values.recordValue(value.longValue());
                }
                if (this.minValue == null || this.minValue.doubleValue() > value.doubleValue()) {
                    this.minValue = value;
                }
                if (this.maxValue == null || this.maxValue.doubleValue() < value.doubleValue()) {
                    this.maxValue = value;
                }
            }
            this.percentiles = percentiles;
        }

        @UserAggregationResult
        public Map<String, Number> result() {
            long totalCount = this.values != null ? this.values.getTotalCount() : this.doubles.getTotalCount();
            boolean empty = totalCount == 0L;
            LinkedHashMap<String, Number> result = new LinkedHashMap<String, Number>(this.percentiles.size() + 6);
            result.put("min", this.minValue);
            result.put("minNonZero", this.values != null ? (double)this.values.getMinNonZeroValue() : this.doubles.getMinNonZeroValue());
            result.put("max", this.maxValue);
            result.put("total", totalCount);
            result.put("mean", this.values != null ? this.values.getMean() : this.doubles.getMean());
            result.put("stdev", this.values != null ? this.values.getStdDeviation() : this.doubles.getStdDeviation());
            for (Double percentile : this.percentiles) {
                if (percentile == null || empty) continue;
                if (this.values != null) {
                    result.put(percentile.toString(), this.values.getValueAtPercentile(percentile * 100.0));
                    continue;
                }
                result.put(percentile.toString(), this.doubles.getValueAtPercentile(percentile * 100.0));
            }
            return result;
        }
    }
}

