/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddressString;
import java.util.List;
import java.util.function.Function;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Settings;

class ApocSettings {
    public static final Function<String, IPAddressString> CIDR_IP = new Function<String, IPAddressString>(){

        @Override
        public IPAddressString apply(String value) {
            IPAddressString ipAddress = new IPAddressString(value.trim());
            try {
                ipAddress.validate();
            }
            catch (AddressStringException e) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid CIDR ip", value), e);
            }
            return ipAddress;
        }

        public String toString() {
            return "an ip with subnet in CDIR format. e.g. 127.168.0.1/8";
        }
    };
    public static final Setting<List<IPAddressString>> cypher_ip_blocklist = Settings.setting((String)"unsupported.dbms.cypher_ip_blocklist", (Function)Settings.list((String)",", CIDR_IP), (String)"");

    ApocSettings() {
    }
}

