/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocConfiguration;
import apoc.Pools;
import apoc.custom.CypherProcedures;
import apoc.cypher.CypherInitializer;
import apoc.index.IndexUpdateTransactionEventHandler;
import apoc.trigger.Trigger;
import apoc.ttl.TTLLifeCycle;
import apoc.util.ApocUrlStreamHandlerFactory;
import apoc.uuid.Uuid;
import java.net.URL;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;

public class ApocKernelExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    public ApocKernelExtensionFactory() {
        super(ExtensionType.DATABASE, "APOC");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) {
        GraphDatabaseAPI db = dependencies.graphdatabaseAPI();
        LogService log = dependencies.log();
        return new ApocLifecycle(log, db, dependencies);
    }

    static {
        try {
            URL.setURLStreamHandlerFactory(new ApocUrlStreamHandlerFactory());
        }
        catch (Error e) {
            System.err.println("APOC couln't set a URLStreamHandlerFactory since some other tool already did this (e.g. tomcat). This means you cannot use s3:// or hdfs:// style URLs in APOC. This is caused by a limitation of the JVM which we cannot fix. ");
        }
    }

    public static class ApocLifecycle
    extends LifecycleAdapter {
        private final LogService log;
        private final GraphDatabaseAPI db;
        private final Dependencies dependencies;
        private Trigger.LifeCycle triggerLifeCycle;
        private Log userLog;
        private TTLLifeCycle ttlLifeCycle;
        private Uuid.UuidLifeCycle uuidLifeCycle;
        private IndexUpdateTransactionEventHandler.LifeCycle indexUpdateLifeCycle;
        private CypherProcedures.CustomProcedureStorage customProcedureStorage;

        public ApocLifecycle(LogService log, GraphDatabaseAPI db, Dependencies dependencies) {
            this.log = log;
            this.db = db;
            this.dependencies = dependencies;
            this.userLog = log.getUserLog(ApocKernelExtensionFactory.class);
        }

        public IndexUpdateTransactionEventHandler.LifeCycle getIndexUpdateLifeCycle() {
            return this.indexUpdateLifeCycle;
        }

        public void start() throws Throwable {
            ApocConfiguration.initialize(this.db);
            Pools.NEO4J_SCHEDULER = this.dependencies.scheduler();
            this.registerCustomProcedures();
            this.ttlLifeCycle = new TTLLifeCycle(Pools.NEO4J_SCHEDULER, this.db, this.log.getUserLog(TTLLifeCycle.class));
            this.ttlLifeCycle.start();
            this.uuidLifeCycle = new Uuid.UuidLifeCycle(this.db, this.log.getUserLog(Uuid.class));
            this.uuidLifeCycle.start();
            this.triggerLifeCycle = new Trigger.LifeCycle(this.db, this.log.getUserLog(Trigger.class));
            this.triggerLifeCycle.start();
            this.indexUpdateLifeCycle = new IndexUpdateTransactionEventHandler.LifeCycle(this.db, this.log.getUserLog(Procedures.class));
            this.indexUpdateLifeCycle.start();
            this.customProcedureStorage = new CypherProcedures.CustomProcedureStorage(Pools.NEO4J_SCHEDULER, this.db, this.log.getUserLog(CypherProcedures.class));
            AvailabilityGuard availabilityGuard = this.dependencies.availabilityGuard();
            availabilityGuard.addListener((AvailabilityListener)this.customProcedureStorage);
            availabilityGuard.addListener((AvailabilityListener)this.triggerLifeCycle);
            availabilityGuard.addListener((AvailabilityListener)new CypherInitializer(this.db, this.log.getUserLog(CypherInitializer.class)));
        }

        public void registerCustomProcedures() {
        }

        public void stop() throws Throwable {
            if (this.ttlLifeCycle != null) {
                try {
                    this.ttlLifeCycle.stop();
                }
                catch (Exception e) {
                    this.userLog.warn("Error stopping ttl service", (Throwable)e);
                }
            }
            if (this.triggerLifeCycle != null) {
                try {
                    this.triggerLifeCycle.stop();
                }
                catch (Exception e) {
                    this.userLog.warn("Error stopping trigger service", (Throwable)e);
                }
            }
            if (this.indexUpdateLifeCycle != null) {
                try {
                    this.indexUpdateLifeCycle.stop();
                }
                catch (Exception e) {
                    this.userLog.warn("Error stopping index update service", (Throwable)e);
                }
            }
            if (this.uuidLifeCycle != null) {
                try {
                    this.uuidLifeCycle.stop();
                }
                catch (Exception e) {
                    this.userLog.warn("Error stopping uuid service", (Throwable)e);
                }
            }
        }
    }

    public static interface Dependencies {
        public GraphDatabaseAPI graphdatabaseAPI();

        public JobScheduler scheduler();

        public Procedures procedures();

        public LogService log();

        public AvailabilityGuard availabilityGuard();
    }
}

