/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.validators;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import org.neo4j.procedure.Procedure;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.DuplicatedProcedureError;
import org.neo4j.tooling.procedure.visitors.AnnotationTypeVisitor;

public class DuplicatedExtensionValidator<T extends Annotation>
implements Function<Collection<Element>, Stream<CompilationMessage>> {
    private final Elements elements;
    private final Class<T> annotationType;
    private final Function<T, Optional<String>> customNameExtractor;

    public DuplicatedExtensionValidator(Elements elements, Class<T> annotationType, Function<T, Optional<String>> customNameExtractor) {
        this.elements = elements;
        this.annotationType = annotationType;
        this.customNameExtractor = customNameExtractor;
    }

    @Override
    public Stream<CompilationMessage> apply(Collection<Element> visitedProcedures) {
        return this.findDuplicates(visitedProcedures);
    }

    private Stream<CompilationMessage> findDuplicates(Collection<Element> visitedProcedures) {
        return this.indexByName(visitedProcedures).filter(index -> ((List)index.getValue()).size() > 1).flatMap(this::asErrors);
    }

    private Stream<Map.Entry<String, List<Element>>> indexByName(Collection<Element> visitedProcedures) {
        return visitedProcedures.stream().collect(Collectors.groupingBy(this::getName)).entrySet().stream();
    }

    private String getName(Element procedure) {
        T annotation = procedure.getAnnotation(this.annotationType);
        Optional<String> customName = this.customNameExtractor.apply(annotation);
        return customName.orElse(this.defaultQualifiedName(procedure));
    }

    private String defaultQualifiedName(Element procedure) {
        return String.format("%s.%s", this.elements.getPackageOf(procedure).toString(), procedure.getSimpleName());
    }

    private Stream<CompilationMessage> asErrors(Map.Entry<String, List<Element>> indexedProcedures) {
        String duplicatedName = indexedProcedures.getKey();
        return indexedProcedures.getValue().stream().map(procedure -> this.asError((Element)procedure, duplicatedName, ((List)indexedProcedures.getValue()).size()));
    }

    private CompilationMessage asError(Element procedure, String duplicatedName, int duplicateCount) {
        return new DuplicatedProcedureError(procedure, this.getAnnotationMirror(procedure), "Procedure|function name <%s> is already defined %s times. It should be defined only once!", duplicatedName, String.valueOf(duplicateCount));
    }

    private AnnotationMirror getAnnotationMirror(Element procedure) {
        return procedure.getAnnotationMirrors().stream().filter(this::isProcedureAnnotationType).findFirst().orElse(null);
    }

    private boolean isProcedureAnnotationType(AnnotationMirror mirror) {
        return (Boolean)new AnnotationTypeVisitor(Procedure.class).visit(mirror.getAnnotationType().asElement());
    }
}

