/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.TypeElement;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.MessagePrinter;
import org.neo4j.tooling.procedure.validators.DuplicatedExtensionValidator;

public class DuplicationAwareBaseProcessor<T extends Annotation>
extends AbstractProcessor {
    private final Set<Element> visitedElements = new LinkedHashSet<Element>();
    private final Class<T> supportedAnnotationType;
    private final Function<T, Optional<String>> customNameFunction;
    private final Function<ProcessingEnvironment, ElementVisitor<Stream<CompilationMessage>, Void>> visitorSupplier;
    private Function<Collection<Element>, Stream<CompilationMessage>> duplicationValidator;
    private ElementVisitor<Stream<CompilationMessage>, Void> visitor;
    private MessagePrinter messagePrinter;

    public DuplicationAwareBaseProcessor(Class<T> supportedAnnotationType, Function<T, Optional<String>> customNameFunction, Function<ProcessingEnvironment, ElementVisitor<Stream<CompilationMessage>, Void>> visitorSupplier) {
        this.supportedAnnotationType = supportedAnnotationType;
        this.customNameFunction = customNameFunction;
        this.visitorSupplier = visitorSupplier;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messagePrinter = new MessagePrinter(processingEnv.getMessager());
        this.duplicationValidator = new DuplicatedExtensionValidator<T>(processingEnv.getElementUtils(), this.supportedAnnotationType, this.customNameFunction);
        this.visitor = this.visitorSupplier.apply(processingEnv);
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.singleton("IgnoreContextWarnings");
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(this.supportedAnnotationType.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processElements(roundEnv);
        if (roundEnv.processingOver()) {
            this.duplicationValidator.apply(this.visitedElements).forEach(this.messagePrinter::print);
        }
        return false;
    }

    private void processElements(RoundEnvironment roundEnv) {
        Set<? extends Element> functions = roundEnv.getElementsAnnotatedWith(this.supportedAnnotationType);
        this.visitedElements.addAll(functions);
        functions.stream().flatMap(this::validate).forEachOrdered(this.messagePrinter::print);
    }

    private Stream<CompilationMessage> validate(Element element) {
        return this.visitor.visit(element);
    }
}

