/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.neo4j.procedure.UserFunction;
import org.neo4j.tooling.procedure.compilerutils.TypeMirrorUtils;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.MessagePrinter;
import org.neo4j.tooling.procedure.validators.DuplicatedProcedureValidator;
import org.neo4j.tooling.procedure.visitors.UserFunctionVisitor;

@AutoService(value=Processor.class)
public class UserFunctionProcessor
extends AbstractProcessor {
    private static final Class<UserFunction> userFunctionType = UserFunction.class;
    private final Set<Element> visitedFunctions = new LinkedHashSet<Element>();
    private ElementVisitor<Stream<CompilationMessage>, Void> visitor;
    private MessagePrinter messagePrinter;
    private Function<Collection<Element>, Stream<CompilationMessage>> duplicationPredicate;

    public static Optional<String> getCustomName(UserFunction function) {
        String name = function.name();
        if (!name.isEmpty()) {
            return Optional.of(name);
        }
        String value = function.value();
        if (!value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(userFunctionType.getName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        this.visitedFunctions.clear();
        this.messagePrinter = new MessagePrinter(processingEnv.getMessager());
        this.visitor = new UserFunctionVisitor(typeUtils, elementUtils, new TypeMirrorUtils(typeUtils, elementUtils));
        this.duplicationPredicate = new DuplicatedProcedureValidator<UserFunction>(elementUtils, userFunctionType, UserFunctionProcessor::getCustomName);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processElements(roundEnv);
        if (roundEnv.processingOver()) {
            this.duplicationPredicate.apply(this.visitedFunctions).forEach(this.messagePrinter::print);
        }
        return false;
    }

    private void processElements(RoundEnvironment roundEnv) {
        Set<? extends Element> functions = roundEnv.getElementsAnnotatedWith(userFunctionType);
        this.visitedFunctions.addAll(functions);
        functions.stream().flatMap(this::validate).forEachOrdered(this.messagePrinter::print);
    }

    private Stream<CompilationMessage> validate(Element element) {
        return this.visitor.visit(element);
    }
}

