/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.neo4j.procedure.Procedure;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.MessagePrinter;
import org.neo4j.tooling.procedure.validators.DuplicatedProcedureValidator;
import org.neo4j.tooling.procedure.visitors.StoredProcedureVisitor;

@AutoService(value=Processor.class)
public class ProcedureProcessor
extends AbstractProcessor {
    private static final Class<Procedure> sprocType = Procedure.class;
    private static final String IGNORE_CONTEXT_WARNINGS = "IgnoreContextWarnings";
    private final Set<Element> visitedProcedures = new LinkedHashSet<Element>();
    private Function<Collection<Element>, Stream<CompilationMessage>> duplicationPredicate;
    private ElementVisitor<Stream<CompilationMessage>, Void> visitor;
    private MessagePrinter messagePrinter;

    public static Optional<String> getCustomName(Procedure proc) {
        String name = proc.name();
        if (!name.isEmpty()) {
            return Optional.of(name);
        }
        String value = proc.value();
        if (!value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.singleton(IGNORE_CONTEXT_WARNINGS);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(sprocType.getName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        this.visitedProcedures.clear();
        this.messagePrinter = new MessagePrinter(processingEnv.getMessager());
        this.visitor = new StoredProcedureVisitor(typeUtils, elementUtils, processingEnv.getOptions().containsKey(IGNORE_CONTEXT_WARNINGS));
        this.duplicationPredicate = new DuplicatedProcedureValidator<Procedure>(elementUtils, sprocType, ProcedureProcessor::getCustomName);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processElements(roundEnv);
        if (roundEnv.processingOver()) {
            this.duplicationPredicate.apply(this.visitedProcedures).forEach(this.messagePrinter::print);
        }
        return false;
    }

    private void processElements(RoundEnvironment roundEnv) {
        Set<? extends Element> procedures = roundEnv.getElementsAnnotatedWith(sprocType);
        this.visitedProcedures.addAll(procedures);
        procedures.stream().flatMap(this::validate).forEachOrdered(this.messagePrinter::print);
    }

    private Stream<CompilationMessage> validate(Element element) {
        return this.visitor.visit(element);
    }
}

