/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure;

import com.google.auto.service.AutoService;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.TypeElement;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.MessagePrinter;
import org.neo4j.tooling.procedure.visitors.PerformsWriteMethodVisitor;

@AutoService(value=Processor.class)
public class PerformsWriteProcessor
extends AbstractProcessor {
    private static final Class<? extends Annotation> performWritesType = PerformsWrites.class;
    private MessagePrinter messagePrinter;
    private ElementVisitor<Stream<CompilationMessage>, Void> visitor;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(performWritesType.getName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messagePrinter = new MessagePrinter(processingEnv.getMessager());
        this.visitor = new PerformsWriteMethodVisitor();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processPerformsWriteElements(roundEnv);
        return false;
    }

    private void processPerformsWriteElements(RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(performWritesType).stream().flatMap(this::validate).forEachOrdered(this.messagePrinter::print);
    }

    private Stream<CompilationMessage> validate(Element element) {
        return this.visitor.visit(element);
    }
}

