/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.visitors;

import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import org.neo4j.procedure.Context;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.FieldError;
import org.neo4j.tooling.procedure.visitors.ContextFieldVisitor;

public class FieldVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private final ElementVisitor<Stream<CompilationMessage>, Void> contextFieldVisitor;

    public FieldVisitor(Types types, Elements elements, boolean skipContextWarnings) {
        this.contextFieldVisitor = new ContextFieldVisitor(types, elements, skipContextWarnings);
    }

    private static Stream<CompilationMessage> validateNonContextField(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            return Stream.of(new FieldError(field, "Field %s#%s should be static", field.getEnclosingElement().getSimpleName(), field.getSimpleName()));
        }
        return Stream.empty();
    }

    @Override
    public Stream<CompilationMessage> visitVariable(VariableElement field, Void ignored) {
        if (field.getAnnotation(Context.class) != null) {
            return this.contextFieldVisitor.visitVariable(field, ignored);
        }
        return FieldVisitor.validateNonContextField(field);
    }
}

