/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.visitors;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLog;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.ContextFieldError;
import org.neo4j.tooling.procedure.messages.ContextFieldWarning;

class ContextFieldVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private static final Set<String> SUPPORTED_TYPES = new LinkedHashSet<String>(List.of(GraphDatabaseService.class.getName(), InternalLog.class.getName(), TerminationGuard.class.getName(), SecurityContext.class.getName(), Transaction.class.getName(), URLAccessChecker.class.getName()));
    private static final Set<String> RESTRICTED_TYPES = new LinkedHashSet<String>(List.of(GraphDatabaseAPI.class.getName(), KernelTransaction.class.getName(), DependencyResolver.class.getName(), "com.neo4j.kernel.enterprise.api.security.EnterpriseAuthManager"));
    private final Elements elements;
    private final Types types;
    private final boolean ignoresWarnings;

    ContextFieldVisitor(Types types, Elements elements, boolean ignoresWarnings) {
        this.elements = elements;
        this.types = types;
        this.ignoresWarnings = ignoresWarnings;
    }

    @Override
    public Stream<CompilationMessage> visitVariable(VariableElement field, Void ignored) {
        return Stream.concat(this.validateModifiers(field), this.validateInjectedTypes(field));
    }

    private Stream<CompilationMessage> validateModifiers(VariableElement field) {
        if (!this.hasValidModifiers(field)) {
            return Stream.of(new ContextFieldError(field, "@%s usage error: field %s should be public, non-static and non-final", Context.class.getName(), this.fieldFullName(field)));
        }
        return Stream.empty();
    }

    private Stream<CompilationMessage> validateInjectedTypes(VariableElement field) {
        TypeMirror fieldType = field.asType();
        if (this.injectsAllowedType(fieldType)) {
            return Stream.empty();
        }
        if (this.injectsRestrictedType(fieldType)) {
            if (this.ignoresWarnings) {
                return Stream.empty();
            }
            return Stream.of(new ContextFieldWarning(field, "@%s usage warning: found unsupported restricted type <%s> on %s.\nThe procedure will not load unless declared via the configuration option 'dbms.security.procedures.unrestricted'.\nYou can ignore this warning by passing the option -A%s to the Java compiler", Context.class.getName(), fieldType.toString(), this.fieldFullName(field), "IgnoreContextWarnings"));
        }
        return Stream.of(new ContextFieldError(field, "@%s usage error: found unknown type <%s> on field %s, expected one of: %s", Context.class.getName(), fieldType.toString(), this.fieldFullName(field), ContextFieldVisitor.joinTypes(SUPPORTED_TYPES)));
    }

    private boolean injectsAllowedType(TypeMirror fieldType) {
        return this.matches(fieldType, SUPPORTED_TYPES);
    }

    private boolean injectsRestrictedType(TypeMirror fieldType) {
        return this.matches(fieldType, RESTRICTED_TYPES);
    }

    private boolean matches(TypeMirror fieldType, Set<String> typeNames) {
        return this.typeMirrors(typeNames).anyMatch(t -> this.types.isSameType((TypeMirror)t, fieldType));
    }

    private boolean hasValidModifiers(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        return modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.FINAL);
    }

    private Stream<TypeMirror> typeMirrors(Set<String> typeNames) {
        return typeNames.stream().map(this.elements::getTypeElement).filter(Objects::nonNull).map(Element::asType);
    }

    private String fieldFullName(VariableElement field) {
        return String.format("%s#%s", field.getEnclosingElement().getSimpleName(), field.getSimpleName());
    }

    private static String joinTypes(Set<String> types) {
        return types.stream().collect(Collectors.joining(">, <", "<", ">"));
    }
}

