/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Collections;
import java.util.Iterator;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;

public abstract class IntegralRangeListValue
extends ListValue {
    @Override
    public final SequenceValue.IterationPreference iterationPreference() {
        return SequenceValue.IterationPreference.RANDOM_ACCESS;
    }

    @Override
    public ValueRepresentation itemValueRepresentation() {
        return ValueRepresentation.INT64;
    }

    public static IntegralRangeListValue rangeList(long start, long end, long step) {
        if (IntegralRangeListValue.isInt(start) && IntegralRangeListValue.isInt(end) && IntegralRangeListValue.isInt(step)) {
            return new IntRangeListValue((int)start, (int)end, (int)step);
        }
        return new IntRangeListValue.LongRangeListValue(start, end, step);
    }

    private static boolean isInt(long value) {
        return (long)((int)value) == value;
    }

    private static final class IntRangeListValue
    extends IntegralRangeListValue {
        private static final long INT_RANGE_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(IntRangeListValue.class);
        private final int start;
        private final int end;
        private final int step;
        private int length = -1;

        IntRangeListValue(int start, int end, int step) {
            this.start = start;
            this.end = end;
            this.step = step;
        }

        @Override
        public String toString() {
            return "Range(" + this.start + "..." + this.end + ", step = " + this.step + ")";
        }

        @Override
        public long actualSize() {
            return this.intSize();
        }

        @Override
        public int intSize() {
            if (this.length == -1) {
                int l = (this.end - this.start) / this.step + 1;
                this.length = Math.max(l, 0);
            }
            return this.length;
        }

        @Override
        public AnyValue value(long offset) {
            if (offset >= (long)this.intSize()) {
                throw new IndexOutOfBoundsException();
            }
            return Values.longValue((long)this.start + offset * (long)this.step);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            final int size = this.intSize();
            if (size == 0) {
                return Collections.emptyIterator();
            }
            return new Iterator<AnyValue>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public AnyValue next() {
                    LongValue result = Values.longValue(start + this.index * step);
                    ++this.index;
                    return result;
                }
            };
        }

        @Override
        protected int computeHashToMemoize() {
            int hashCode = 1;
            int current = this.start;
            int size = this.intSize();
            int i = 0;
            while (i < size) {
                hashCode = 31 * hashCode + Long.hashCode(current);
                ++i;
                current += this.step;
            }
            return hashCode;
        }

        public long estimatedHeapUsage() {
            return INT_RANGE_LIST_VALUE_SHALLOW_SIZE;
        }

        @Override
        public ArrayValue toStorableArray() {
            int size = this.intSize();
            if (size < 0) {
                throw new org.neo4j.exceptions.ArithmeticException("numeric value out of range");
            }
            int current = this.start;
            long[] array = new long[size];
            int i = 0;
            while (i < size) {
                array[i] = current;
                ++i;
                current += this.step;
            }
            return Values.longArray(array);
        }

        private static final class LongRangeListValue
        extends IntegralRangeListValue {
            private static final long LONG_RANGE_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LongRangeListValue.class);
            private final long start;
            private final long end;
            private final long step;

            LongRangeListValue(long start, long end, long step) {
                this.start = start;
                this.end = end;
                this.step = step;
            }

            @Override
            public String toString() {
                return "Range(" + this.start + "..." + this.end + ", step = " + this.step + ")";
            }

            @Override
            public long actualSize() {
                long diff = (this.end - this.start) / this.step;
                if (diff < 0L) {
                    return 0L;
                }
                try {
                    return Math.addExact(diff, 1L);
                }
                catch (ArithmeticException e) {
                    throw new org.neo4j.exceptions.ArithmeticException("numeric value out of range", (Throwable)e);
                }
            }

            @Override
            public Iterator<AnyValue> iterator() {
                final long size = this.actualSize();
                if (size == 0L) {
                    return Collections.emptyIterator();
                }
                return new Iterator<AnyValue>(){
                    private long index = 0L;

                    @Override
                    public boolean hasNext() {
                        return this.index < size;
                    }

                    @Override
                    public AnyValue next() {
                        LongValue result = Values.longValue(start + this.index * step);
                        ++this.index;
                        return result;
                    }
                };
            }

            @Override
            public AnyValue value(long offset) {
                if (offset >= this.actualSize()) {
                    throw new IndexOutOfBoundsException();
                }
                return Values.longValue(this.start + offset * this.step);
            }

            @Override
            protected int computeHashToMemoize() {
                int hashCode = 1;
                long current = this.start;
                int size = (int)Math.min(this.actualSize(), Integer.MAX_VALUE);
                int i = 0;
                while (i < size) {
                    hashCode = 31 * hashCode + Long.hashCode(current);
                    ++i;
                    current += this.step;
                }
                return hashCode;
            }

            public long estimatedHeapUsage() {
                return LONG_RANGE_LIST_VALUE_SHALLOW_SIZE;
            }

            @Override
            public ArrayValue toStorableArray() {
                int size = (int)this.actualSize();
                if (size < 0) {
                    throw new org.neo4j.exceptions.ArithmeticException("numeric value out of range");
                }
                long current = this.start;
                long[] array = new long[size];
                int i = 0;
                while (i < size) {
                    array[i] = current;
                    ++i;
                    current += this.step;
                }
                return Values.longArray(array);
            }
        }
    }
}

