/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public enum ValueRepresentation {
    UNKNOWN(ValueGroup.UNKNOWN, false){

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return UNKNOWN;
        }
    }
    ,
    GEOMETRY_ARRAY(ValueGroup.GEOMETRY_ARRAY, false),
    ZONED_DATE_TIME_ARRAY(ValueGroup.ZONED_DATE_TIME_ARRAY, false),
    LOCAL_DATE_TIME_ARRAY(ValueGroup.LOCAL_DATE_TIME_ARRAY, false),
    DATE_ARRAY(ValueGroup.DATE_ARRAY, false),
    ZONED_TIME_ARRAY(ValueGroup.ZONED_TIME_ARRAY, false),
    LOCAL_TIME_ARRAY(ValueGroup.LOCAL_TIME_ARRAY, false),
    DURATION_ARRAY(ValueGroup.DURATION_ARRAY, false),
    TEXT_ARRAY(ValueGroup.TEXT_ARRAY, false),
    BOOLEAN_ARRAY(ValueGroup.BOOLEAN_ARRAY, false),
    INT64_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    INT32_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    INT16_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    INT8_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    FLOAT64_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    FLOAT32_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    GEOMETRY(ValueGroup.GEOMETRY, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            PointValue[] points = new PointValue[values.length()];
            int i = 0;
            PointValue first = null;
            for (AnyValue value : values) {
                PointValue current = ValueRepresentation.getOrFail(value, PointValue.class);
                if (first == null) {
                    first = current;
                } else {
                    if (!first.getCoordinateReferenceSystem().equals(current.getCoordinateReferenceSystem())) {
                        throw new CypherTypeException("Collections containing point values with different CRS can not be stored in properties.");
                    }
                    if (first.coordinate().length != current.coordinate().length) {
                        throw new CypherTypeException("Collections containing point values with different dimensions can not be stored in properties.");
                    }
                }
                points[i++] = current;
            }
            return Values.pointArray(points);
        }
    }
    ,
    ZONED_DATE_TIME(ValueGroup.ZONED_DATE_TIME, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            ZonedDateTime[] temporals = new ZonedDateTime[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ValueRepresentation.getOrFail(value, DateTimeValue.class).temporal();
            }
            return Values.dateTimeArray(temporals);
        }
    }
    ,
    LOCAL_DATE_TIME(ValueGroup.LOCAL_DATE_TIME, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            LocalDateTime[] temporals = new LocalDateTime[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ValueRepresentation.getOrFail(value, LocalDateTimeValue.class).temporal();
            }
            return Values.localDateTimeArray(temporals);
        }
    }
    ,
    DATE(ValueGroup.DATE, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            LocalDate[] temporals = new LocalDate[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ValueRepresentation.getOrFail(value, DateValue.class).temporal();
            }
            return Values.dateArray(temporals);
        }
    }
    ,
    ZONED_TIME(ValueGroup.ZONED_TIME, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            OffsetTime[] temporals = new OffsetTime[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ((TimeValue)value).temporal();
            }
            return Values.timeArray(temporals);
        }
    }
    ,
    LOCAL_TIME(ValueGroup.LOCAL_TIME, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            LocalTime[] temporals = new LocalTime[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ((LocalTimeValue)value).temporal();
            }
            return Values.localTimeArray(temporals);
        }
    }
    ,
    DURATION(ValueGroup.DURATION, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            DurationValue[] temporals = new DurationValue[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = (DurationValue)value;
            }
            return Values.durationArray(temporals);
        }
    }
    ,
    UTF16_TEXT(ValueGroup.TEXT, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            String[] strings = new String[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                strings[i++] = ((TextValue)value).stringValue();
            }
            return Values.stringArray(strings);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            switch (other) {
                case UTF8_TEXT: 
                case UTF16_TEXT: {
                    return UTF16_TEXT;
                }
            }
            return UNKNOWN;
        }
    }
    ,
    UTF8_TEXT(ValueGroup.TEXT, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            String[] strings = new String[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                strings[i++] = ((TextValue)value).stringValue();
            }
            return Values.stringArray(strings);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            switch (other) {
                case UTF8_TEXT: {
                    return UTF8_TEXT;
                }
                case UTF16_TEXT: {
                    return UTF16_TEXT;
                }
            }
            return UNKNOWN;
        }
    }
    ,
    BOOLEAN(ValueGroup.BOOLEAN, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            boolean[] bools = new boolean[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                bools[i++] = ((BooleanValue)value).booleanValue();
            }
            return Values.booleanArray(bools);
        }
    }
    ,
    INT64(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            long[] longs = new long[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                longs[i++] = ValueRepresentation.getOrFail(value, NumberValue.class).longValue();
            }
            return Values.longArray(longs);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            switch (other) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: {
                    return this;
                }
                case FLOAT32: 
                case FLOAT64: {
                    return FLOAT64;
                }
            }
            return UNKNOWN;
        }
    }
    ,
    INT32(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            int[] ints = new int[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                ints[i++] = ValueRepresentation.getOrFail(value, IntegralValue.class).intValue();
            }
            return Values.intArray(ints);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            switch (other) {
                case INT8: 
                case INT16: 
                case INT32: {
                    return this;
                }
                case INT64: {
                    return INT64;
                }
                case FLOAT32: 
                case FLOAT64: {
                    return FLOAT64;
                }
            }
            return UNKNOWN;
        }
    }
    ,
    INT16(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            short[] shorts = new short[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                shorts[i++] = ValueRepresentation.getOrFail(value, IntegralValue.class).shortValue();
            }
            return Values.shortArray(shorts);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            switch (other) {
                case INT8: 
                case INT16: {
                    return this;
                }
                case INT32: {
                    return INT32;
                }
                case INT64: {
                    return INT64;
                }
                case FLOAT32: {
                    return FLOAT32;
                }
                case FLOAT64: {
                    return FLOAT64;
                }
            }
            return UNKNOWN;
        }
    }
    ,
    INT8(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            byte[] bytes = new byte[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                bytes[i++] = ValueRepresentation.getOrFail(value, ByteValue.class).value();
            }
            return Values.byteArray(bytes);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            switch (other) {
                case INT8: {
                    return this;
                }
                case INT16: {
                    return INT16;
                }
                case INT32: {
                    return INT32;
                }
                case INT64: {
                    return INT64;
                }
                case FLOAT32: {
                    return FLOAT32;
                }
                case FLOAT64: {
                    return FLOAT64;
                }
            }
            return UNKNOWN;
        }
    }
    ,
    FLOAT64(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            double[] doubles = new double[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                doubles[i++] = ((NumberValue)value).doubleValue();
            }
            return Values.doubleArray(doubles);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            switch (other) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: {
                    return this;
                }
            }
            return UNKNOWN;
        }
    }
    ,
    FLOAT32(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            float[] floats = new float[values.length()];
            int i = 0;
            for (AnyValue value : values) {
                NumberValue asNumberValue = ValueRepresentation.getOrFail(value, NumberValue.class);
                floats[i] = asNumberValue instanceof FloatValue ? ((FloatValue)asNumberValue).value() : (float)asNumberValue.longValue();
                ++i;
            }
            return Values.floatArray(floats);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            switch (other) {
                case INT8: 
                case INT16: 
                case FLOAT32: {
                    return this;
                }
                case INT32: 
                case INT64: 
                case FLOAT64: {
                    return FLOAT64;
                }
            }
            return UNKNOWN;
        }
    }
    ,
    NO_VALUE(ValueGroup.NO_VALUE, false);

    private final ValueGroup group;
    private final boolean canCreateArrayOf;

    private ValueRepresentation(ValueGroup group, boolean canCreateArrayOf) {
        this.group = group;
        this.canCreateArrayOf = canCreateArrayOf;
    }

    public boolean canCreateArrayOfValueGroup() {
        return this.canCreateArrayOf;
    }

    public ValueGroup valueGroup() {
        return this.group;
    }

    public ArrayValue arrayOf(SequenceValue values) {
        AnyValue prev = null;
        for (AnyValue value : values) {
            if (value == Values.NO_VALUE) {
                throw new CypherTypeException("Collections containing null values can not be stored in properties.");
            }
            if (value instanceof SequenceValue) {
                throw new CypherTypeException("Collections containing collections can not be stored in properties.");
            }
            if (prev != null && prev.valueRepresentation().valueGroup() != value.valueRepresentation().valueGroup()) {
                throw new CypherTypeException("Neo4j only supports a subset of Cypher types for storage as singleton or array properties. Please refer to section cypher/syntax/values of the manual for more details.");
            }
            if (!value.valueRepresentation().canCreateArrayOfValueGroup()) {
                throw new CypherTypeException(String.format("Property values can only be of primitive types or arrays thereof. Encountered: %s.", value));
            }
            prev = value;
        }
        throw ValueRepresentation.failure();
    }

    public ValueRepresentation coerce(ValueRepresentation other) {
        return this.valueGroup() == other.valueGroup() ? this : UNKNOWN;
    }

    private static <T> T getOrFail(AnyValue value, Class<T> type) {
        if (type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        if (value == Values.NO_VALUE) {
            throw new CypherTypeException("Collections containing null values can not be stored in properties.");
        }
        if (value instanceof SequenceValue) {
            throw new CypherTypeException("Collections containing collections can not be stored in properties.");
        }
        throw ValueRepresentation.failure();
    }

    private static CypherTypeException failure() {
        return new CypherTypeException("Property values can only be of primitive types or arrays thereof");
    }
}

