/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.hashing.HashFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Equality;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public final class NoValue
extends Value {
    public static final NoValue NO_VALUE = new NoValue();

    private NoValue() {
    }

    @Override
    public boolean equalTo(Object other) {
        return this == other;
    }

    @Override
    public Equality ternaryEquals(AnyValue other) {
        return Equality.UNDEFINED;
    }

    @Override
    boolean ternaryUndefined() {
        return true;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapNoValue();
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return hashFunction.update(hash, (long)this.hashCode());
    }

    @Override
    protected int computeHash() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Value other) {
        return this == other;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeNull();
    }

    @Override
    public Object asObjectCopy() {
        return null;
    }

    public String toString() {
        return this.prettyPrint();
    }

    @Override
    public String prettyPrint() {
        return this.getTypeName();
    }

    @Override
    public String getTypeName() {
        return "NO_VALUE";
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.NO_VALUE;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    int unsafeCompareTo(Value other) {
        return 0;
    }

    public long estimatedHeapUsage() {
        return 0L;
    }
}

