/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.HashMap;
import java.util.List;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.ErrorValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.RelationshipValue;

public final class VirtualValues {
    public static final MapValue EMPTY_MAP = MapValue.EMPTY;
    public static final ListValue EMPTY_LIST = new ListValue.ArrayListValue(new AnyValue[0], 0L);

    private VirtualValues() {
    }

    public static ListValue list(AnyValue ... values) {
        long payloadSize = 0L;
        for (AnyValue value : values) {
            payloadSize += value.estimatedHeapUsage();
        }
        return new ListValue.ArrayListValue(values, payloadSize);
    }

    public static ListValue fromList(List<AnyValue> values) {
        long payloadSize = 0L;
        for (AnyValue value : values) {
            payloadSize += value.estimatedHeapUsage();
        }
        return new ListValue.JavaListListValue(values, payloadSize);
    }

    public static ListValue fromList(List<AnyValue> values, long payloadSize) {
        return new ListValue.JavaListListValue(values, payloadSize);
    }

    public static ListValue range(long start, long end, long step) {
        return new ListValue.IntegralRangeListValue(start, end, step);
    }

    public static ListValue fromArray(ArrayValue arrayValue) {
        return new ListValue.ArrayValueListValue(arrayValue);
    }

    public static ListValue concat(ListValue ... lists) {
        return new ListValue.ConcatList(lists);
    }

    public static MapValue map(String[] keys, AnyValue[] values) {
        assert (keys.length == values.length);
        long payloadSize = 0L;
        HashMap<String, AnyValue> map = new HashMap<String, AnyValue>((int)((float)keys.length / 0.75f + 1.0f));
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            AnyValue value = values[i];
            map.put(key, value);
            payloadSize += HeapEstimator.sizeOf((String)key) + value.estimatedHeapUsage();
        }
        return new MapValue.MapWrappingMapValue(map, payloadSize);
    }

    public static ErrorValue error(Exception e) {
        return new ErrorValue(e);
    }

    public static NodeReference node(long id) {
        return new NodeReference(id);
    }

    public static RelationshipReference relationship(long id) {
        return new RelationshipReference(id);
    }

    public static PathValue path(NodeValue[] nodes, RelationshipValue[] relationships) {
        assert (nodes != null);
        assert (relationships != null);
        if ((nodes.length + relationships.length) % 2 == 0) {
            throw new IllegalArgumentException("Tried to construct a path that is not built like a path: even number of elements");
        }
        long payloadSize = 0L;
        for (NodeValue nodeValue : nodes) {
            payloadSize += nodeValue.estimatedHeapUsage();
        }
        for (VirtualValue virtualValue : relationships) {
            payloadSize += virtualValue.estimatedHeapUsage();
        }
        return new PathValue.DirectPathValue(nodes, relationships, payloadSize);
    }

    public static NodeValue nodeValue(long id, TextArray labels, MapValue properties) {
        return new NodeValue.DirectNodeValue(id, labels, properties);
    }

    public static RelationshipValue relationshipValue(long id, NodeValue startNode, NodeValue endNode, TextValue type, MapValue properties) {
        return new RelationshipValue.DirectRelationshipValue(id, startNode, endNode, type, properties);
    }
}

