/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;

public abstract class NodeValue
extends VirtualNodeValue {
    private final long id;
    private static final long DIRECT_NODE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DirectNodeValue.class);

    protected NodeValue(long id) {
        this.id = id;
    }

    public abstract TextArray labels();

    public abstract MapValue properties();

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writeNodeReference(this.id);
        } else {
            writer.writeNode(this.id, this.labels(), this.properties());
        }
    }

    @Override
    public long id() {
        return this.id;
    }

    public String toString() {
        return String.format("(%d)", this.id);
    }

    @Override
    public String getTypeName() {
        return "Node";
    }

    static class DirectNodeValue
    extends NodeValue {
        private final TextArray labels;
        private final MapValue properties;

        DirectNodeValue(long id, TextArray labels, MapValue properties) {
            super(id);
            assert (labels != null);
            assert (properties != null);
            this.labels = labels;
            this.properties = properties;
        }

        @Override
        public TextArray labels() {
            return this.labels;
        }

        @Override
        public MapValue properties() {
            return this.properties;
        }

        public long estimatedHeapUsage() {
            return DIRECT_NODE_SHALLOW_SIZE + this.labels.estimatedHeapUsage() + this.properties.estimatedHeapUsage();
        }
    }
}

