/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

final class StringWrappingStringValue
extends StringValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StringWrappingStringValue.class);
    private final String value;

    StringWrappingStringValue(String value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    String value() {
        return this.value;
    }

    @Override
    public int length() {
        return this.value.codePointCount(0, this.value.length());
    }

    @Override
    protected int computeHashToMemoize() {
        int codePoint;
        if (this.value.isEmpty()) {
            return 0;
        }
        int h = 1;
        int length = this.value.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = this.value.codePointAt(offset);
            h = 31 * h + codePoint;
        }
        return h;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return StringWrappingStringValue.updateHash(hashFunction, hash, this.value);
    }

    public static long updateHash(HashFunction hashFunction, long hash, String value) {
        int length = value.length();
        int codePointCount = 0;
        int offset = 0;
        while (offset < length) {
            int codePointA = value.codePointAt(offset);
            int codePointB = 0;
            ++codePointCount;
            if ((offset += Character.charCount(codePointA)) < length) {
                codePointB = value.codePointAt(offset);
                offset += Character.charCount(codePointB);
                ++codePointCount;
            }
            hash = hashFunction.update(hash, ((long)codePointA << 32) + (long)codePointB);
        }
        return hashFunction.update(hash, (long)codePointCount);
    }

    @Override
    public TextValue substring(int start, int length) {
        int s = Math.min(start, this.length());
        int e = Math.min(s + length, this.length());
        int codePointStart = this.value.offsetByCodePoints(0, s);
        int codePointEnd = this.value.offsetByCodePoints(0, e);
        return Values.stringValue(this.value.substring(codePointStart, codePointEnd));
    }

    @Override
    public TextValue trim() {
        int start = this.ltrimIndex(this.value);
        int end = this.rtrimIndex(this.value);
        return Values.stringValue(this.value.substring(start, Math.max(end, start)));
    }

    @Override
    public TextValue ltrim() {
        int start = this.ltrimIndex(this.value);
        return Values.stringValue(this.value.substring(start));
    }

    @Override
    public TextValue rtrim() {
        int end = this.rtrimIndex(this.value);
        return Values.stringValue(this.value.substring(0, end));
    }

    @Override
    public TextValue reverse() {
        StringBuilder stringBuilder = new StringBuilder(this.value());
        return Values.stringValue(stringBuilder.reverse().toString());
    }

    @Override
    public TextValue plus(TextValue other) {
        return new StringWrappingStringValue(this.value + other.stringValue());
    }

    @Override
    public boolean startsWith(TextValue other) {
        return this.value.startsWith(other.stringValue());
    }

    @Override
    public boolean endsWith(TextValue other) {
        return this.value.endsWith(other.stringValue());
    }

    @Override
    public boolean contains(TextValue other) {
        return this.value.contains(other.stringValue());
    }

    @Override
    Matcher matcher(Pattern pattern) {
        return pattern.matcher(this.value);
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((String)this.value);
    }

    private int ltrimIndex(String value) {
        int start;
        int codePoint;
        int length = value.length();
        for (start = 0; start < length && Character.isWhitespace(codePoint = value.codePointAt(start)); start += Character.charCount(codePoint)) {
        }
        return start;
    }

    private int rtrimIndex(String value) {
        int codePoint;
        int end;
        for (end = value.length(); end > 0 && Character.isWhitespace(codePoint = value.codePointBefore(end)); --end) {
        }
        return end;
    }
}

