/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.HashMemoizingScalarValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class TextValue
extends HashMemoizingScalarValue {
    static final ListValue EMPTY_SPLIT = VirtualValues.fromArray(Values.stringArray("", ""));

    TextValue() {
    }

    public abstract String stringValue();

    public abstract int length();

    public abstract TextValue substring(int var1, int var2);

    public TextValue substring(int start) {
        return this.substring(start, Math.max(this.length() - start, start));
    }

    public abstract TextValue trim();

    public abstract TextValue ltrim();

    public abstract TextValue rtrim();

    public abstract TextValue toLower();

    public abstract TextValue toUpper();

    public abstract ListValue split(String var1);

    public abstract ListValue split(List<String> var1);

    public abstract TextValue replace(String var1, String var2);

    public abstract TextValue reverse();

    public abstract TextValue plus(TextValue var1);

    public abstract boolean startsWith(TextValue var1);

    public abstract boolean endsWith(TextValue var1);

    public abstract boolean contains(TextValue var1);

    public abstract int compareTo(TextValue var1);

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareTo((TextValue)otherValue);
    }

    @Override
    public final boolean equals(boolean x) {
        return false;
    }

    @Override
    public final boolean equals(long x) {
        return false;
    }

    @Override
    public final boolean equals(double x) {
        return false;
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.TEXT;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapText(this);
    }

    abstract Matcher matcher(Pattern var1);
}

