/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.ValueWriter;

public final class ByteValue
extends IntegralValue {
    private final byte value;

    ByteValue(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeInteger(this.value);
    }

    @Override
    public Byte asObjectCopy() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Byte.toString(this.value);
    }

    public String toString() {
        return String.format("%s(%d)", this.getTypeName(), this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapByte(this);
    }

    @Override
    public String getTypeName() {
        return "Byte";
    }

    @Override
    protected long estimatedPayloadSize() {
        return 1L;
    }
}

