/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.utils.UnsupportedTemporalUnitException;
import org.neo4j.values.virtual.MapValue;

public final class LocalTimeValue
extends TemporalValue<LocalTime, LocalTimeValue> {
    public static final LocalTimeValue MIN_VALUE = new LocalTimeValue(LocalTime.MIN);
    public static final LocalTimeValue MAX_VALUE = new LocalTimeValue(LocalTime.MAX);
    static final LocalTime DEFAULT_LOCAL_TIME = LocalTime.of(TemporalValue.TemporalFields.hour.defaultValue, TemporalValue.TemporalFields.minute.defaultValue);
    private final LocalTime value;
    static final String TIME_PATTERN = "(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:\\.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:\\.(?<shortFraction>[0-9]{1,9}))?)?)?))";
    private static final Pattern PATTERN = Pattern.compile("(?:T)?(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:\\.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:\\.(?<shortFraction>[0-9]{1,9}))?)?)?))");

    public static LocalTimeValue localTime(LocalTime value) {
        return new LocalTimeValue(Objects.requireNonNull(value, "LocalTime"));
    }

    public static LocalTimeValue localTime(int hour, int minute, int second, int nanosOfSecond) {
        return new LocalTimeValue(LocalTimeValue.assertValidArgument(() -> LocalTime.of(hour, minute, second, nanosOfSecond)));
    }

    public static LocalTimeValue localTime(long nanoOfDay) {
        return new LocalTimeValue(LocalTimeValue.localTimeRaw(nanoOfDay));
    }

    public static LocalTime localTimeRaw(long nanoOfDay) {
        return LocalTimeValue.assertValidArgument(() -> LocalTime.ofNanoOfDay(nanoOfDay));
    }

    public static LocalTimeValue parse(CharSequence text) {
        return LocalTimeValue.parse(LocalTimeValue.class, PATTERN, LocalTimeValue::parse, text);
    }

    public static LocalTimeValue parse(TextValue text) {
        return LocalTimeValue.parse(LocalTimeValue.class, PATTERN, LocalTimeValue::parse, text);
    }

    public static LocalTimeValue now(Clock clock) {
        return new LocalTimeValue(LocalTime.now(clock));
    }

    public static LocalTimeValue now(Clock clock, String timezone) {
        return LocalTimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static LocalTimeValue now(Clock clock, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.now(clock.withZone(defaultZone.get()));
    }

    public static LocalTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return (LocalTimeValue)StructureBuilder.build(LocalTimeValue.builder(defaultZone), map);
    }

    public static LocalTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.builder(defaultZone).selectTime(from);
    }

    public static LocalTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        LocalTime localTime = input.getLocalTimePart();
        LocalTime truncatedLT = LocalTimeValue.assertValidUnit(() -> localTime.truncatedTo(unit));
        if (fields.size() == 0) {
            return LocalTimeValue.localTime(truncatedLT);
        }
        return LocalTimeValue.updateFieldMapWithConflictingSubseconds(fields, unit, truncatedLT, (mapValue, localTime1) -> {
            if (mapValue.size() == 0) {
                return LocalTimeValue.localTime(localTime1);
            }
            return LocalTimeValue.build(mapValue.updatedWith("time", LocalTimeValue.localTime(localTime1)), defaultZone);
        });
    }

    static TimeValue.TimeBuilder<LocalTimeValue> builder(Supplier<ZoneId> defaultZone) {
        return new TimeValue.TimeBuilder<LocalTimeValue>(defaultZone){

            @Override
            protected boolean supportsTimeZone() {
                return false;
            }

            @Override
            public LocalTimeValue buildInternal() {
                LocalTime result;
                if (this.fields.containsKey((Object)TemporalValue.TemporalFields.time)) {
                    AnyValue time = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.time);
                    if (!(time instanceof TemporalValue)) {
                        throw new InvalidValuesArgumentException(String.format("Cannot construct local time from: %s", time));
                    }
                    result = ((TemporalValue)time).getLocalTimePart();
                } else {
                    result = DEFAULT_LOCAL_TIME;
                }
                result = this.assignAllFields(result);
                return LocalTimeValue.localTime(result);
            }

            @Override
            protected LocalTimeValue selectTime(AnyValue time) {
                if (!(time instanceof TemporalValue)) {
                    throw new InvalidValuesArgumentException(String.format("Cannot construct local time from: %s", time));
                }
                TemporalValue v = (TemporalValue)time;
                LocalTime lt = v.getLocalTimePart();
                return LocalTimeValue.localTime(lt);
            }
        };
    }

    private LocalTimeValue(LocalTime value) {
        this.value = value;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        LocalTimeValue other = (LocalTimeValue)otherValue;
        return this.value.compareTo(other.value);
    }

    @Override
    LocalTime temporal() {
        return this.value;
    }

    @Override
    public String getTypeName() {
        return "LocalTime";
    }

    @Override
    LocalDate getDatePart() {
        throw new UnsupportedTemporalUnitException(String.format("Cannot get the date of: %s", this));
    }

    @Override
    LocalTime getLocalTimePart() {
        return this.value;
    }

    @Override
    OffsetTime getTimePart(Supplier<ZoneId> defaultZone) {
        ZoneOffset currentOffset = LocalTimeValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.now(), (ZoneId)defaultZone.get())).getOffset();
        return OffsetTime.of(this.value, currentOffset);
    }

    @Override
    ZoneId getZoneId(Supplier<ZoneId> defaultZone) {
        return defaultZone.get();
    }

    @Override
    ZoneId getZoneId() {
        throw new UnsupportedTemporalUnitException(String.format("Cannot get the timezone of: %s", this));
    }

    @Override
    ZoneOffset getZoneOffset() {
        throw new UnsupportedTemporalUnitException(String.format("Cannot get the offset of: %s", this));
    }

    @Override
    public boolean supportsTimeZone() {
        return false;
    }

    @Override
    boolean hasTime() {
        return true;
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof LocalTimeValue && this.value.equals(((LocalTimeValue)other).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeLocalTime(this.value);
    }

    @Override
    public String prettyPrint() {
        return LocalTimeValue.assertPrintable(() -> this.value.format(DateTimeFormatter.ISO_LOCAL_TIME));
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.LOCAL_TIME;
    }

    @Override
    protected int computeHash() {
        return this.value.hashCode();
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalTime(this);
    }

    @Override
    public LocalTimeValue add(DurationValue duration) {
        return this.replacement(LocalTimeValue.assertValidArithmetic(() -> this.value.plusNanos(duration.nanosOfDay())));
    }

    @Override
    public LocalTimeValue sub(DurationValue duration) {
        return this.replacement(LocalTimeValue.assertValidArithmetic(() -> this.value.minusNanos(duration.nanosOfDay())));
    }

    @Override
    LocalTimeValue replacement(LocalTime time) {
        return time == this.value ? this : new LocalTimeValue(time);
    }

    private static LocalTimeValue parse(Matcher matcher) {
        return new LocalTimeValue(LocalTimeValue.parseTime(matcher));
    }

    static LocalTime parseTime(Matcher matcher) {
        int fraction;
        int second;
        int minute;
        int hour;
        String longHour = matcher.group("longHour");
        if (longHour != null) {
            hour = Integer.parseInt(longHour);
            minute = LocalTimeValue.optInt(matcher.group("longMinute"));
            second = LocalTimeValue.optInt(matcher.group("longSecond"));
            fraction = LocalTimeValue.parseNanos(matcher.group("longFraction"));
        } else {
            String shortHour = matcher.group("shortHour");
            hour = Integer.parseInt(shortHour);
            minute = LocalTimeValue.optInt(matcher.group("shortMinute"));
            second = LocalTimeValue.optInt(matcher.group("shortSecond"));
            fraction = LocalTimeValue.parseNanos(matcher.group("shortFraction"));
        }
        return LocalTimeValue.assertParsable(() -> LocalTime.of(hour, minute, second, fraction));
    }

    private static int parseNanos(String value) {
        if (value == null) {
            return 0;
        }
        int nanos = Integer.parseInt(value);
        if (nanos != 0) {
            for (int i = value.length(); i < 9; ++i) {
                nanos *= 10;
            }
        }
        return nanos;
    }

    static int optInt(String value) {
        return value == null ? 0 : Integer.parseInt(value);
    }
}

