/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class FloatArray
extends FloatingPointArray {
    private final float[] value;

    FloatArray(float[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public double doubleValue(int index) {
        return this.value[index];
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapFloatArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(long[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(float[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public float[] asObjectCopy() {
        return (float[])this.value.clone();
    }

    @Deprecated
    public float[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int offset) {
        return Values.floatValue(this.value[offset]);
    }

    public String toString() {
        return String.format("FloatArray%s", Arrays.toString(this.value));
    }
}

