/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PointFields;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

public class PointValue
extends ScalarValue
implements Point,
Comparable<PointValue> {
    public static String[] ALLOWED_KEYS = new String[]{"crs", "x", "y", "z", "longitude", "latitude", "height", "srid"};
    private CoordinateReferenceSystem crs;
    private double[] coordinate;

    PointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        this.crs = crs;
        this.coordinate = coordinate;
        for (double c : coordinate) {
            if (Double.isFinite(c)) continue;
            throw new InvalidValuesArgumentException("Cannot create a point with non-finite coordinate values: " + Arrays.toString(coordinate));
        }
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writePoint(this.getCoordinateReferenceSystem(), this.coordinate);
    }

    @Override
    public String prettyPrint() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        ((Value)this).writeTo(prettyPrinter);
        return prettyPrinter.value();
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.GEOMETRY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof PointValue) {
            PointValue pv = (PointValue)other;
            return Arrays.equals(this.coordinate, pv.coordinate) && this.getCoordinateReferenceSystem().equals(pv.getCoordinateReferenceSystem());
        }
        return false;
    }

    public boolean equals(Point other) {
        if (!other.getCRS().getHref().equals(this.getCRS().getHref())) {
            return false;
        }
        List otherCoordinate = other.getCoordinate().getCoordinate();
        if (otherCoordinate.size() != this.coordinate.length) {
            return false;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            if ((Double)otherCoordinate.get(i) == this.coordinate[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean eq(Object other) {
        return other != null && (other instanceof Value && this.equals((Value)other) || other instanceof Point && this.equals((Point)other));
    }

    @Override
    public int compareTo(PointValue other) {
        int cmpCRS = this.crs.getCode() - other.crs.getCode();
        if (cmpCRS != 0) {
            return cmpCRS;
        }
        if (this.coordinate.length > other.coordinate.length) {
            return 1;
        }
        if (this.coordinate.length < other.coordinate.length) {
            return -1;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal == 0) continue;
            return cmpVal;
        }
        return 0;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareTo((PointValue)otherValue);
    }

    @Override
    Comparison unsafeTernaryCompareTo(Value otherValue) {
        PointValue other = (PointValue)otherValue;
        if (this.crs.getCode() != other.crs.getCode() || this.coordinate.length != other.coordinate.length) {
            return Comparison.UNDEFINED;
        }
        int eq = 0;
        int gt = 0;
        int lt = 0;
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal > 0) {
                ++gt;
                continue;
            }
            if (cmpVal < 0) {
                ++lt;
                continue;
            }
            ++eq;
        }
        if (eq == this.coordinate.length) {
            return Comparison.EQUAL;
        }
        if (gt == this.coordinate.length) {
            return Comparison.GREATER_THAN;
        }
        if (lt == this.coordinate.length) {
            return Comparison.SMALLER_THAN;
        }
        if (lt == 0) {
            return Comparison.GREATER_THAN_AND_EQUAL;
        }
        if (gt == 0) {
            return Comparison.SMALLER_THAN_AND_EQUAL;
        }
        return Comparison.UNDEFINED;
    }

    public Point asObjectCopy() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public double[] coordinate() {
        return this.coordinate;
    }

    @Override
    public int computeHash() {
        int result = 1;
        result = 31 * result + NumberValues.hash(this.crs.getCode());
        result = 31 * result + NumberValues.hash(this.coordinate);
        return result;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, (long)this.crs.getCode());
        for (double v : this.coordinate) {
            hash = hashFunction.update(hash, Double.doubleToLongBits(v));
        }
        return hash;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPoint(this);
    }

    public String toString() {
        String coordString = this.coordinate.length == 2 ? String.format("x: %s, y: %s", this.coordinate[0], this.coordinate[1]) : String.format("x: %s, y: %s, z: %s", this.coordinate[0], this.coordinate[1], this.coordinate[2]);
        return String.format("point({%s, crs: '%s'})", coordString, this.getCoordinateReferenceSystem().getName());
    }

    @Override
    public String getTypeName() {
        return "Point";
    }

    public String toIndexableString() {
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        return String.format("P:%d-%d%s", crs.getTable().getTableId(), crs.getCode(), Arrays.toString(this.coordinate));
    }

    public List<Coordinate> getCoordinates() {
        return Collections.singletonList(new Coordinate(this.coordinate));
    }

    public CRS getCRS() {
        return this.crs;
    }

    public Boolean withinRange(PointValue lower, boolean includeLower, PointValue upper, boolean includeUpper) {
        Comparison comparison;
        if (lower == null && upper == null) {
            return true;
        }
        if (lower != null && upper != null && ((comparison = lower.unsafeTernaryCompareTo(upper)) == Comparison.UNDEFINED || comparison == Comparison.GREATER_THAN || comparison == Comparison.GREATER_THAN_AND_EQUAL)) {
            return null;
        }
        if (lower != null) {
            comparison = this.unsafeTernaryCompareTo(lower);
            if (comparison == Comparison.UNDEFINED) {
                return null;
            }
            if (comparison == Comparison.SMALLER_THAN || comparison == Comparison.SMALLER_THAN_AND_EQUAL || (comparison == Comparison.EQUAL || comparison == Comparison.GREATER_THAN_AND_EQUAL) && !includeLower) {
                if (upper != null && this.unsafeTernaryCompareTo(upper) == Comparison.UNDEFINED) {
                    return null;
                }
                return false;
            }
        }
        if (upper != null) {
            comparison = this.unsafeTernaryCompareTo(upper);
            if (comparison == Comparison.UNDEFINED) {
                return null;
            }
            if (comparison == Comparison.GREATER_THAN || comparison == Comparison.GREATER_THAN_AND_EQUAL || (comparison == Comparison.EQUAL || comparison == Comparison.SMALLER_THAN_AND_EQUAL) && !includeUpper) {
                return false;
            }
        }
        return true;
    }

    public static PointValue fromMap(MapValue map) {
        PointBuilder fields = new PointBuilder();
        for (Map.Entry<String, AnyValue> entry : map.entrySet()) {
            fields.assign(entry.getKey().toLowerCase(), entry.getValue());
        }
        return PointValue.fromInputFields(fields);
    }

    public static PointValue parse(CharSequence text) {
        return PointValue.parse(text, null);
    }

    public static PointValue parse(CharSequence text, CSVHeaderInformation fieldsFromHeader) {
        PointBuilder fieldsFromData = PointValue.parseHeaderInformation(text);
        if (fieldsFromHeader != null) {
            if (!(fieldsFromHeader instanceof PointBuilder)) {
                throw new IllegalStateException("Wrong header information type: " + fieldsFromHeader);
            }
            fieldsFromData.mergeWithHeader((PointBuilder)fieldsFromHeader);
        }
        return PointValue.fromInputFields(fieldsFromData);
    }

    public static PointBuilder parseHeaderInformation(CharSequence text) {
        PointBuilder fields = new PointBuilder();
        Value.parseHeaderInformation(text, "point", fields);
        return fields;
    }

    private static CoordinateReferenceSystem findSpecifiedCRS(PointBuilder fields) {
        String crsValue = fields.crs;
        int sridValue = fields.srid;
        if (crsValue != null && sridValue != -1) {
            throw new InvalidValuesArgumentException("Cannot specify both CRS and SRID");
        }
        if (crsValue != null) {
            return CoordinateReferenceSystem.byName(crsValue);
        }
        if (sridValue != -1) {
            return CoordinateReferenceSystem.get(sridValue);
        }
        return null;
    }

    private static PointValue fromInputFields(PointBuilder fields) {
        double[] coordinates;
        CoordinateReferenceSystem crs = PointValue.findSpecifiedCRS(fields);
        if (fields.x != null && fields.y != null) {
            double[] dArray;
            if (fields.z != null) {
                double[] dArray2 = new double[3];
                dArray2[0] = fields.x;
                dArray2[1] = fields.y;
                dArray = dArray2;
                dArray2[2] = fields.z;
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = fields.x;
                dArray = dArray3;
                dArray3[1] = fields.y;
            }
            coordinates = dArray;
            if (crs == null) {
                crs = coordinates.length == 3 ? CoordinateReferenceSystem.Cartesian_3D : CoordinateReferenceSystem.Cartesian;
            }
        } else if (fields.latitude != null && fields.longitude != null) {
            coordinates = fields.z != null ? new double[]{fields.longitude, fields.latitude, fields.z} : (fields.height != null ? new double[]{fields.longitude, fields.latitude, fields.height} : new double[]{fields.longitude, fields.latitude});
            if (crs == null) {
                CoordinateReferenceSystem coordinateReferenceSystem = crs = coordinates.length == 3 ? CoordinateReferenceSystem.WGS84_3D : CoordinateReferenceSystem.WGS84;
            }
            if (!crs.isGeographic()) {
                throw new InvalidValuesArgumentException("Geographic points does not support coordinate reference system: " + crs + ". This is set either in the csv header or the actual data column");
            }
        } else {
            if (crs == CoordinateReferenceSystem.Cartesian) {
                throw new InvalidValuesArgumentException("A " + CoordinateReferenceSystem.Cartesian.getName() + " point must contain 'x' and 'y'");
            }
            if (crs == CoordinateReferenceSystem.Cartesian_3D) {
                throw new InvalidValuesArgumentException("A " + CoordinateReferenceSystem.Cartesian_3D.getName() + " point must contain 'x', 'y' and 'z'");
            }
            if (crs == CoordinateReferenceSystem.WGS84) {
                throw new InvalidValuesArgumentException("A " + CoordinateReferenceSystem.WGS84.getName() + " point must contain 'latitude' and 'longitude'");
            }
            if (crs == CoordinateReferenceSystem.WGS84_3D) {
                throw new InvalidValuesArgumentException("A " + CoordinateReferenceSystem.WGS84_3D.getName() + " point must contain 'latitude', 'longitude' and 'height'");
            }
            throw new InvalidValuesArgumentException("A point must contain either 'x' and 'y' or 'latitude' and 'longitude'");
        }
        if (crs.getDimension() != coordinates.length) {
            throw new InvalidValuesArgumentException("Cannot create point with " + crs.getDimension() + "D coordinate reference system and " + coordinates.length + " coordinates. Please consider using equivalent " + coordinates.length + "D coordinate reference system");
        }
        return Values.pointValue(crs, coordinates);
    }

    public Value get(String fieldName) {
        return PointFields.fromName(fieldName).get(this);
    }

    DoubleValue getNthCoordinate(int n, String fieldName, boolean onlyGeographic) {
        if (onlyGeographic && !this.getCoordinateReferenceSystem().isGeographic()) {
            throw new InvalidValuesArgumentException("Field: " + fieldName + " is not available on cartesian point: " + this);
        }
        if (n >= this.coordinate().length) {
            throw new InvalidValuesArgumentException("Field: " + fieldName + " is not available on point: " + this);
        }
        return Values.doubleValue(this.coordinate[n]);
    }

    private static class PointBuilder
    implements CSVHeaderInformation {
        private String crs;
        private Double x;
        private Double y;
        private Double z;
        private Double longitude;
        private Double latitude;
        private Double height;
        private int srid = -1;
        private boolean allowOpenMaps = true;

        private PointBuilder() {
        }

        @Override
        public void assign(String key, Object value) {
            switch (key.toLowerCase()) {
                case "crs": {
                    this.checkUnassigned(this.crs, key);
                    this.assignTextValue(key, value, str -> {
                        this.crs = Value.quotesPattern.matcher((CharSequence)str).replaceAll("");
                    });
                    break;
                }
                case "x": {
                    this.checkUnassigned(this.x, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.x = i;
                    });
                    break;
                }
                case "y": {
                    this.checkUnassigned(this.y, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.y = i;
                    });
                    break;
                }
                case "z": {
                    this.checkUnassigned(this.z, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.z = i;
                    });
                    break;
                }
                case "longitude": {
                    this.checkUnassigned(this.longitude, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.longitude = i;
                    });
                    break;
                }
                case "latitude": {
                    this.checkUnassigned(this.latitude, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.latitude = i;
                    });
                    break;
                }
                case "height": {
                    this.checkUnassigned(this.height, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.height = i;
                    });
                    break;
                }
                case "srid": {
                    if (this.srid != -1) {
                        throw new InvalidValuesArgumentException(String.format("Duplicate field '%s' is not allowed.", key));
                    }
                    this.assignIntegral(key, value, i -> {
                        this.srid = i;
                    });
                    break;
                }
                default: {
                    if (this.allowOpenMaps) break;
                    this.throwOnUnrecognizedKey(key);
                }
            }
        }

        void mergeWithHeader(PointBuilder header) {
            this.crs = this.crs == null ? header.crs : this.crs;
            this.x = this.x == null ? header.x : this.x;
            this.y = this.y == null ? header.y : this.y;
            this.z = this.z == null ? header.z : this.z;
            this.longitude = this.longitude == null ? header.longitude : this.longitude;
            this.latitude = this.latitude == null ? header.latitude : this.latitude;
            this.height = this.height == null ? header.height : this.height;
            this.srid = this.srid == -1 ? header.srid : this.srid;
        }

        private void assignTextValue(String key, Object value, Consumer<String> assigner) {
            if (value instanceof String) {
                assigner.accept((String)value);
            } else if (value instanceof TextValue) {
                assigner.accept(((TextValue)value).stringValue());
            } else {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", value, key));
            }
        }

        private void assignFloatingPoint(String key, Object value, Consumer<Double> assigner) {
            if (value instanceof String) {
                assigner.accept(this.assertConvertible(() -> Double.parseDouble((String)value)));
            } else if (value instanceof IntegralValue) {
                assigner.accept(((IntegralValue)value).doubleValue());
            } else if (value instanceof FloatingPointValue) {
                assigner.accept(((FloatingPointValue)value).doubleValue());
            } else {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", value, key));
            }
        }

        private void assignIntegral(String key, Object value, Consumer<Integer> assigner) {
            if (value instanceof String) {
                assigner.accept(this.assertConvertible(() -> Integer.parseInt((String)value)));
            } else if (value instanceof IntegralValue) {
                assigner.accept((int)((IntegralValue)value).longValue());
            } else {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", value, key));
            }
        }

        private void throwOnUnrecognizedKey(String key) {
            throw new InvalidValuesArgumentException(String.format("Unknown key '%s' for creating new point", key));
        }

        private <T extends Number> T assertConvertible(Supplier<T> func) {
            try {
                return (T)((Number)func.get());
            }
            catch (NumberFormatException e) {
                throw new InvalidValuesArgumentException(e.getMessage(), e);
            }
        }

        private void checkUnassigned(Object key, String fieldName) {
            if (key != null) {
                throw new InvalidValuesArgumentException(String.format("Duplicate field '%s' is not allowed.", fieldName));
            }
        }
    }
}

