/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public abstract class StringArray
extends TextArray {
    abstract String[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    @Override
    public String stringValue(int offset) {
        return this.value()[offset];
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(char[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(String[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public final boolean eq(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SequenceValue) {
            return this.equals((SequenceValue)other);
        }
        return other instanceof Value && this.equals((Value)other);
    }

    @Override
    public int computeHash() {
        return Arrays.hashCode(this.value());
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value().clone();
    }

    @Override
    @Deprecated
    public Object asObject() {
        return this.value();
    }

    @Override
    public int compareTo(TextArray other) {
        return TextValues.compareTextArrays(this, other);
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value());
    }

    @Override
    public AnyValue value(int offset) {
        return Values.stringValue(this.stringValue(offset));
    }

    static final class Direct
    extends StringArray {
        final String[] value;

        Direct(String[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        String[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value()));
        }

        @Override
        public String getTypeName() {
            return "StringArray";
        }
    }
}

