/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ArrayHelpers;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class ListValue
extends VirtualValue
implements SequenceValue,
Iterable<AnyValue> {
    public abstract int size();

    @Override
    public abstract AnyValue value(int var1);

    public abstract AnyValue[] asArray();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return this.size() != 0;
    }

    public boolean storable() {
        return false;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("List{");
        for (i = 0; i < this.size() - 1; ++i) {
            sb.append(this.value(i));
            sb.append(", ");
        }
        if (this.size() > 0) {
            sb.append(this.value(i));
        }
        sb.append('}');
        return sb.toString();
    }

    public ArrayValue toStorableArray() {
        throw new UnsupportedOperationException("List cannot be turned into a storable array");
    }

    @Override
    public boolean isSequenceValue() {
        return true;
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (other == null || !other.isSequenceValue()) {
            return false;
        }
        return this.equals((SequenceValue)((Object)other));
    }

    public AnyValue head() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.value(0);
    }

    public AnyValue last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("last of empty list");
        }
        return this.value(size - 1);
    }

    @Override
    public Iterator<AnyValue> iterator() {
        return new Iterator<AnyValue>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < ListValue.this.size();
            }

            @Override
            public AnyValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ListValue.this.value(this.count++);
            }
        };
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.LIST;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (!(other instanceof ListValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        if (other instanceof DropNoValuesListValue) {
            return -other.compareTo(this, comparator);
        }
        ListValue otherList = (ListValue)other;
        int x = Integer.compare(this.length(), otherList.length());
        if (x == 0) {
            for (int i = 0; i < this.length(); ++i) {
                x = comparator.compare(this.value(i), otherList.value(i));
                if (x == 0) continue;
                return x;
            }
        }
        return x;
    }

    @Override
    public int length() {
        return this.size();
    }

    static final class ConcatList
    extends ListValue {
        private final ListValue[] lists;
        private int size = -1;

        ConcatList(ListValue[] lists) {
            this.lists = lists;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                int s = 0;
                for (ListValue list : this.lists) {
                    s += list.size();
                }
                this.size = s;
            }
            return this.size;
        }

        @Override
        public AnyValue value(int offset) {
            for (ListValue list : this.lists) {
                int size = list.size();
                if (offset < size) {
                    return list.value(offset);
                }
                offset -= size;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public AnyValue[] asArray() {
            AnyValue[] values = new AnyValue[this.size()];
            int start = 0;
            for (ListValue list : this.lists) {
                int length = list.length();
                System.arraycopy(list.asArray(), 0, values, start, length);
                start += length;
            }
            return values;
        }

        @Override
        public int computeHash() {
            int hashCode = 1;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                hashCode = 31 * hashCode + this.value(i).hashCode();
            }
            return hashCode;
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            writer.beginList(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.value(i).writeTo(writer);
            }
            writer.endList();
        }
    }

    static final class IntegralRangeListValue
    extends ListValue {
        private final long start;
        private final long end;
        private final long step;
        private int length = -1;

        IntegralRangeListValue(long start, long end, long step) {
            this.start = start;
            this.end = end;
            this.step = step;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            int size = this.size();
            writer.beginList(size);
            long current = this.start;
            while (this.check(current)) {
                ((Value)Values.longValue(current)).writeTo(writer);
                current += this.step;
            }
            writer.endList();
        }

        @Override
        public String toString() {
            return "Range(" + this.start + "..." + this.end + ", step = " + this.step + ")";
        }

        private boolean check(long current) {
            if (this.step > 0L) {
                return current <= this.end;
            }
            return current >= this.end;
        }

        @Override
        public int size() {
            if (this.length != -1) {
                return this.length;
            }
            long l = (this.end - this.start) / this.step + 1L;
            if (l > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("Cannot index an collection of size " + l);
            }
            this.length = (int)l;
            return this.length;
        }

        @Override
        public AnyValue value(int offset) {
            if (offset >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return Values.longValue(this.start + (long)offset * this.step);
        }

        @Override
        public AnyValue[] asArray() {
            int len = this.size();
            AnyValue[] anyValues = new AnyValue[len];
            int i = 0;
            long current = this.start;
            while (this.check(current)) {
                anyValues[i] = Values.longValue(current);
                current += this.step;
                ++i;
            }
            return anyValues;
        }

        @Override
        public int computeHash() {
            int hashCode = 1;
            long current = this.start;
            int size = this.size();
            int i = 0;
            while (i < size) {
                hashCode = 31 * hashCode + Long.hashCode(current);
                ++i;
                current += this.step;
            }
            return hashCode;
        }
    }

    static final class DropNoValuesListValue
    extends ListValue {
        private final ListValue inner;
        private int size = -1;

        DropNoValuesListValue(ListValue inner) {
            this.inner = inner;
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            writer.beginList(this.size());
            for (int i = 0; i < this.inner.size(); ++i) {
                AnyValue value = this.inner.value(i);
                if (value == Values.NO_VALUE) continue;
                value.writeTo(writer);
            }
            writer.endList();
        }

        @Override
        public int size() {
            if (this.size < 0) {
                int s = 0;
                for (int i = 0; i < this.inner.size(); ++i) {
                    if (this.inner.value(i) == Values.NO_VALUE) continue;
                    ++s;
                }
                this.size = s;
            }
            return this.size;
        }

        @Override
        public AnyValue value(int offset) {
            int actualOffset = 0;
            int size = this.inner.size();
            for (int i = 0; i < size; ++i) {
                AnyValue value = this.inner.value(i);
                if (value == Values.NO_VALUE) continue;
                if (actualOffset == offset) {
                    return value;
                }
                ++actualOffset;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public AnyValue[] asArray() {
            int len = this.size();
            AnyValue[] anyValues = new AnyValue[len];
            int index = 0;
            for (int i = 0; i < this.inner.size(); ++i) {
                AnyValue value = this.inner.value(i);
                if (value == Values.NO_VALUE) continue;
                anyValues[index++] = value;
            }
            return anyValues;
        }

        @Override
        public int computeHash() {
            int hashCode = 1;
            for (int i = 0; i < this.inner.size(); ++i) {
                AnyValue value = this.inner.value(i);
                if (value == Values.NO_VALUE) continue;
                hashCode = 31 * hashCode + value.hashCode();
            }
            return hashCode;
        }

        @Override
        public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
            if (!(other instanceof ListValue)) {
                throw new IllegalArgumentException("Cannot compare different virtual values");
            }
            ListValue otherList = (ListValue)other;
            Iterator<AnyValue> thisIterator = this.iterator();
            Iterator<AnyValue> thatIterator = otherList.iterator();
            while (thisIterator.hasNext()) {
                if (!thatIterator.hasNext()) {
                    return 1;
                }
                int compare = comparator.compare(thisIterator.next(), thatIterator.next());
                if (compare == 0) continue;
                return compare;
            }
            if (thatIterator.hasNext()) {
                return -1;
            }
            return 0;
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return new FilteredIterator();
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        private class FilteredIterator
        implements Iterator<AnyValue> {
            private AnyValue next;
            private int index;

            FilteredIterator() {
                this.computeNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public AnyValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AnyValue current = this.next;
                this.computeNext();
                return current;
            }

            private void computeNext() {
                if (this.index < DropNoValuesListValue.this.inner.size()) {
                    AnyValue candidate;
                    do {
                        if (this.index < DropNoValuesListValue.this.inner.size()) continue;
                        this.next = null;
                        return;
                    } while ((candidate = DropNoValuesListValue.this.inner.value(this.index++)) == Values.NO_VALUE);
                    this.next = candidate;
                    return;
                }
                this.next = null;
            }
        }
    }

    static final class ReversedList
    extends ListValue {
        private final ListValue inner;

        ReversedList(ListValue inner) {
            this.inner = inner;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            writer.beginList(this.size());
            for (int i = this.inner.size() - 1; i >= 0; --i) {
                this.inner.value(i).writeTo(writer);
            }
            writer.endList();
        }

        @Override
        public int size() {
            return this.inner.size();
        }

        @Override
        public AnyValue value(int offset) {
            return this.inner.value(this.size() - 1 - offset);
        }

        @Override
        public AnyValue[] asArray() {
            int len = this.size();
            AnyValue[] anyValues = new AnyValue[len];
            for (int i = 0; i < len; ++i) {
                anyValues[i] = this.value(i);
            }
            return anyValues;
        }

        @Override
        public int computeHash() {
            int hashCode = 1;
            for (int i = this.inner.size() - 1; i >= 0; --i) {
                hashCode = 31 * hashCode + this.inner.value(i).hashCode();
            }
            return hashCode;
        }
    }

    static final class ListSlice
    extends ListValue {
        private final ListValue inner;
        private final int from;
        private final int to;

        ListSlice(ListValue inner, int from, int to) {
            assert (from >= 0);
            assert (to <= inner.size());
            assert (from <= to);
            this.inner = inner;
            this.from = from;
            this.to = to;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            writer.beginList(this.size());
            for (int i = this.from; i < this.to; ++i) {
                this.inner.value(i).writeTo(writer);
            }
            writer.endList();
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public AnyValue value(int offset) {
            return this.inner.value(offset + this.from);
        }

        @Override
        public AnyValue[] asArray() {
            int len = this.size();
            AnyValue[] anyValues = new AnyValue[len];
            int index = 0;
            for (int i = this.from; i < this.to; ++i) {
                anyValues[index++] = this.inner.value(i);
            }
            return anyValues;
        }

        @Override
        public int computeHash() {
            int hashCode = 1;
            for (int i = this.from; i < this.to; ++i) {
                hashCode = 31 * hashCode + this.inner.value(i).hashCode();
            }
            return hashCode;
        }
    }

    static final class JavaListListValue
    extends ListValue {
        private final List<AnyValue> values;

        JavaListListValue(List<AnyValue> values) {
            assert (values != null);
            assert (!ArrayHelpers.containsNull(values));
            this.values = values;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            writer.beginList(this.values.size());
            for (AnyValue value : this.values) {
                value.writeTo(writer);
            }
            writer.endList();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public AnyValue value(int offset) {
            return this.values.get(offset);
        }

        @Override
        public AnyValue[] asArray() {
            return this.values.toArray(new AnyValue[this.values.size()]);
        }

        @Override
        public int computeHash() {
            return this.values.hashCode();
        }
    }

    static final class ArrayListValue
    extends ListValue {
        private final AnyValue[] values;

        ArrayListValue(AnyValue[] values) {
            assert (values != null);
            assert (!ArrayHelpers.containsNull(values));
            this.values = values;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            writer.beginList(this.values.length);
            for (AnyValue value : this.values) {
                value.writeTo(writer);
            }
            writer.endList();
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public AnyValue value(int offset) {
            return this.values[offset];
        }

        @Override
        public AnyValue[] asArray() {
            return this.values;
        }

        @Override
        public int computeHash() {
            return Arrays.hashCode(this.values);
        }
    }

    static final class ArrayValueListValue
    extends ListValue {
        private final ArrayValue array;

        ArrayValueListValue(ArrayValue array) {
            this.array = array;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            int length = this.array.length();
            writer.beginList(length);
            for (int i = 0; i < length; ++i) {
                this.array.value(i).writeTo(writer);
            }
            writer.endList();
        }

        @Override
        public boolean storable() {
            return true;
        }

        @Override
        public ArrayValue toStorableArray() {
            return this.array;
        }

        @Override
        public int size() {
            return this.array.length();
        }

        @Override
        public AnyValue value(int offset) {
            return this.array.value(offset);
        }

        @Override
        public AnyValue[] asArray() {
            int size = this.size();
            AnyValue[] values = new AnyValue[size];
            for (int i = 0; i < size; ++i) {
                values[i] = this.array.value(i);
            }
            return values;
        }

        @Override
        public int computeHash() {
            return this.array.hashCode();
        }
    }
}

