/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueComparator;

public final class Values {
    public static final Value MIN_NUMBER = Values.doubleValue(Double.NEGATIVE_INFINITY);
    public static final Value MAX_NUMBER = Values.doubleValue(Double.NaN);
    public static final Value ZERO_FLOAT = Values.doubleValue(0.0);
    public static final Value ZERO_INT = Values.longValue(0L);
    public static final Value MIN_STRING = Values.stringValue("");
    public static final Value MAX_STRING = Values.booleanValue(false);
    public static final BooleanValue TRUE = Values.booleanValue(true);
    public static final BooleanValue FALSE = Values.booleanValue(false);
    public static final TextValue EMPTY_STRING = Values.stringValue("");
    public static final DoubleValue E = Values.doubleValue(Math.E);
    public static final DoubleValue PI = Values.doubleValue(Math.PI);
    public static final ArrayValue EMPTY_SHORT_ARRAY = Values.shortArray(new short[0]);
    public static final ArrayValue EMPTY_BOOLEAN_ARRAY = Values.booleanArray(new boolean[0]);
    public static final ArrayValue EMPTY_BYTE_ARRAY = Values.byteArray(new byte[0]);
    public static final ArrayValue EMPTY_CHAR_ARRAY = Values.charArray(new char[0]);
    public static final ArrayValue EMPTY_INT_ARRAY = Values.intArray(new int[0]);
    public static final ArrayValue EMPTY_LONG_ARRAY = Values.longArray(new long[0]);
    public static final ArrayValue EMPTY_FLOAT_ARRAY = Values.floatArray(new float[0]);
    public static final ArrayValue EMPTY_DOUBLE_ARRAY = Values.doubleArray(new double[0]);
    public static final Comparator<Value> COMPARATOR = new ValueComparator(Enum::compareTo);
    public static final Value NO_VALUE = NoValue.NO_VALUE;

    private Values() {
    }

    public static boolean isNumberValue(Object value) {
        return value instanceof NumberValue;
    }

    public static boolean isBooleanValue(Object value) {
        return value instanceof BooleanValue;
    }

    public static boolean isTextValue(Object value) {
        return value instanceof TextValue;
    }

    public static boolean isArrayValue(Value value) {
        return value instanceof ArrayValue;
    }

    public static double coerceToDouble(Value value) {
        if (value instanceof IntegralValue) {
            return ((IntegralValue)value).longValue();
        }
        if (value instanceof FloatingPointValue) {
            return ((FloatingPointValue)value).doubleValue();
        }
        throw new UnsupportedOperationException(String.format("Cannot coerce %s to double", value));
    }

    public static TextValue utf8Value(byte[] bytes) {
        return Values.utf8Value(bytes, 0, bytes.length);
    }

    public static TextValue utf8Value(byte[] bytes, int offset, int length) {
        return new StringValue.UTF8StringValue(bytes, offset, length);
    }

    public static TextValue stringValue(String value) {
        return new StringValue.Direct(value);
    }

    public static Value stringOrNoValue(String value) {
        if (value == null) {
            return NO_VALUE;
        }
        return new StringValue.Direct(value);
    }

    public static Value numberValue(Number number) {
        if (number instanceof Long) {
            return Values.longValue(number.longValue());
        }
        if (number instanceof Integer) {
            return Values.intValue(number.intValue());
        }
        if (number instanceof Double) {
            return Values.doubleValue(number.doubleValue());
        }
        if (number instanceof Byte) {
            return Values.byteValue(number.byteValue());
        }
        if (number instanceof Float) {
            return Values.floatValue(number.floatValue());
        }
        if (number instanceof Short) {
            return Values.shortValue(number.shortValue());
        }
        if (number == null) {
            return NO_VALUE;
        }
        throw new UnsupportedOperationException("Unsupported type of Number " + number.toString());
    }

    public static LongValue longValue(long value) {
        return new LongValue(value);
    }

    public static IntValue intValue(int value) {
        return new IntValue(value);
    }

    public static ShortValue shortValue(short value) {
        return new ShortValue(value);
    }

    public static ByteValue byteValue(byte value) {
        return new ByteValue(value);
    }

    public static BooleanValue booleanValue(boolean value) {
        return new BooleanValue(value);
    }

    public static CharValue charValue(char value) {
        return new CharValue(value);
    }

    public static DoubleValue doubleValue(double value) {
        return new DoubleValue(value);
    }

    public static FloatValue floatValue(float value) {
        return new FloatValue(value);
    }

    public static TextArray stringArray(String ... value) {
        return new StringArray.Direct(value);
    }

    public static ByteArray byteArray(byte[] value) {
        return new ByteArray.Direct(value);
    }

    public static LongArray longArray(long[] value) {
        return new LongArray.Direct(value);
    }

    public static IntArray intArray(int[] value) {
        return new IntArray.Direct(value);
    }

    public static DoubleArray doubleArray(double[] value) {
        return new DoubleArray.Direct(value);
    }

    public static FloatArray floatArray(float[] value) {
        return new FloatArray.Direct(value);
    }

    public static BooleanArray booleanArray(boolean[] value) {
        return new BooleanArray.Direct(value);
    }

    public static CharArray charArray(char[] value) {
        return new CharArray.Direct(value);
    }

    public static ShortArray shortArray(short[] value) {
        return new ShortArray.Direct(value);
    }

    public static Value of(Object value) {
        return Values.of(value, true);
    }

    public static Value of(Object value, boolean allowNull) {
        if (value instanceof String) {
            return Values.stringValue((String)value);
        }
        if (value instanceof Object[]) {
            return Values.arrayValue((Object[])value);
        }
        if (value instanceof Boolean) {
            return Values.booleanValue((Boolean)value);
        }
        if (value instanceof Number) {
            return Values.numberValue((Number)value);
        }
        if (value instanceof Character) {
            return Values.charValue(((Character)value).charValue());
        }
        if (value instanceof byte[]) {
            return Values.byteArray((byte[])((byte[])value).clone());
        }
        if (value instanceof long[]) {
            return Values.longArray((long[])((long[])value).clone());
        }
        if (value instanceof int[]) {
            return Values.intArray((int[])((int[])value).clone());
        }
        if (value instanceof double[]) {
            return Values.doubleArray((double[])((double[])value).clone());
        }
        if (value instanceof float[]) {
            return Values.floatArray((float[])((float[])value).clone());
        }
        if (value instanceof boolean[]) {
            return Values.booleanArray((boolean[])((boolean[])value).clone());
        }
        if (value instanceof char[]) {
            return Values.charArray((char[])((char[])value).clone());
        }
        if (value instanceof short[]) {
            return Values.shortArray((short[])((short[])value).clone());
        }
        if (value == null) {
            if (allowNull) {
                return NoValue.NO_VALUE;
            }
            throw new IllegalArgumentException("[null] is not a supported property value");
        }
        if (value instanceof Value) {
            throw new UnsupportedOperationException("Converting a Value to a Value using Values.of() is not supported.");
        }
        throw new IllegalArgumentException(String.format("[%s:%s] is not a supported property value", value, value.getClass().getName()));
    }

    public static Value[] values(Object ... objects) {
        return (Value[])Arrays.stream(objects).map(Values::of).toArray(Value[]::new);
    }

    @Deprecated
    public static Object asObject(Value value) {
        return value == null ? null : value.asObject();
    }

    public static Object[] asObjects(Value[] propertyValues) {
        Object[] legacy = new Object[propertyValues.length];
        for (int i = 0; i < propertyValues.length; ++i) {
            legacy[i] = propertyValues[i].asObjectCopy();
        }
        return legacy;
    }

    private static Value arrayValue(Object[] value) {
        if (value instanceof String[]) {
            return Values.stringArray(Values.copy(value, new String[value.length]));
        }
        if (value instanceof Byte[]) {
            return Values.byteArray(Values.copy(value, new byte[value.length]));
        }
        if (value instanceof Long[]) {
            return Values.longArray(Values.copy(value, new long[value.length]));
        }
        if (value instanceof Integer[]) {
            return Values.intArray(Values.copy(value, new int[value.length]));
        }
        if (value instanceof Double[]) {
            return Values.doubleArray(Values.copy(value, new double[value.length]));
        }
        if (value instanceof Float[]) {
            return Values.floatArray(Values.copy(value, new float[value.length]));
        }
        if (value instanceof Boolean[]) {
            return Values.booleanArray(Values.copy(value, new boolean[value.length]));
        }
        if (value instanceof Character[]) {
            return Values.charArray(Values.copy(value, new char[value.length]));
        }
        if (value instanceof Short[]) {
            return Values.shortArray(Values.copy(value, new short[value.length]));
        }
        throw new IllegalArgumentException(String.format("%s[] is not a supported property value type", value.getClass().getComponentType().getName()));
    }

    private static <T> T copy(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException("Property array value elements may not be null.");
            }
            Array.set(target, i, value[i]);
        }
        return target;
    }
}

