/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.nio.charset.StandardCharsets;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

public abstract class StringValue
extends TextValue {
    abstract String value();

    @Override
    public boolean eq(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value value) {
        return value.equals(this.value());
    }

    @Override
    public boolean equals(char x) {
        return this.value().length() == 1 && this.value().charAt(0) == x;
    }

    @Override
    public boolean equals(String x) {
        return this.value().equals(x);
    }

    @Override
    public int computeHash() {
        return this.value().hashCode();
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value();
    }

    public String toString() {
        return String.format("String(\"%s\")", this.value());
    }

    @Override
    public int compareTo(TextValue other) {
        return this.value().compareTo(other.stringValue());
    }

    @Override
    public String stringValue() {
        return this.value();
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", this.value());
    }

    static final class UTF8StringValue
    extends StringValue {
        private volatile String value;
        private final byte[] bytes;
        private final int offset;
        private final int length;

        UTF8StringValue(byte[] bytes, int offset, int length) {
            assert (bytes != null);
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
            writer.writeUTF8(this.bytes, this.offset, this.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        String value() {
            String s = this.value;
            if (s == null) {
                UTF8StringValue uTF8StringValue = this;
                synchronized (uTF8StringValue) {
                    s = this.value;
                    if (s == null) {
                        s = this.value = new String(this.bytes, this.offset, this.length, StandardCharsets.UTF_8);
                    }
                }
            }
            return s;
        }

        @Override
        public int length() {
            return this.value().length();
        }
    }

    static final class Direct
    extends StringValue {
        final String value;

        Direct(String value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        String value() {
            return this.value;
        }

        @Override
        public int length() {
            return this.value.length();
        }
    }
}

