/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.NonUniqueTokenException;

public class TokenRegistry {
    private final String tokenType;
    private volatile Registries registries;

    public TokenRegistry(String tokenType) {
        this.tokenType = tokenType;
        this.registries = new Registries();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public synchronized void setInitialTokens(List<NamedToken> tokens) {
        this.registries = this.insertAllChecked(tokens, new Registries());
    }

    public void put(NamedToken token) {
        this.put(token, true);
    }

    public synchronized void put(NamedToken token, boolean atomic) {
        Registries reg = this.registries;
        if (reg.idToToken.containsKey(token.id())) {
            NamedToken existingToken = (NamedToken)reg.idToToken.get(token.id());
            if (token.equals(existingToken)) {
                return;
            }
            throw new NonUniqueTokenException(this.tokenType, token, existingToken);
        }
        if (atomic) {
            reg = reg.copy();
        }
        if (token.isInternal()) {
            this.checkNameUniqueness(reg.internalNameToId, token, reg);
            reg.internalNameToId.put((Object)token.name(), token.id());
        } else {
            this.checkNameUniqueness(reg.publicNameToId, token, reg);
            reg.publicNameToId.put((Object)token.name(), token.id());
        }
        reg.idToToken.put(token.id(), (Object)token);
        this.registries = reg;
    }

    public synchronized void putAll(List<NamedToken> tokens) {
        this.registries = this.insertAllChecked(tokens, this.registries.copy());
    }

    public int getId(String name) {
        return TokenRegistry.getIdForName(this.registries.publicNameToId, name);
    }

    public int getIdInternal(String name) {
        return TokenRegistry.getIdForName(this.registries.internalNameToId, name);
    }

    public NamedToken getToken(int id) {
        NamedToken token = (NamedToken)this.registries.idToToken.get(id);
        return token == null || token.isInternal() ? null : token;
    }

    public NamedToken getTokenInternal(int id) {
        NamedToken token = (NamedToken)this.registries.idToToken.get(id);
        return token != null && token.isInternal() ? token : null;
    }

    public Collection<NamedToken> allTokens() {
        Registries reg = this.registries;
        ArrayList<NamedToken> list = new ArrayList<NamedToken>(reg.idToToken.size());
        for (NamedToken token : reg.idToToken) {
            if (token.isInternal()) continue;
            list.add(token);
        }
        return Collections.unmodifiableCollection(list);
    }

    public Collection<NamedToken> allInternalTokens() {
        Registries reg = this.registries;
        ArrayList<NamedToken> list = new ArrayList<NamedToken>();
        for (NamedToken token : reg.idToToken) {
            if (!token.isInternal()) continue;
            list.add(token);
        }
        return Collections.unmodifiableCollection(list);
    }

    public boolean hasToken(int id) {
        return this.registries.idToToken.containsKey(id);
    }

    public int size() {
        return this.registries.publicNameToId.size();
    }

    public int sizeInternal() {
        return this.registries.internalNameToId.size();
    }

    private Registries insertAllChecked(List<NamedToken> tokens, Registries registries) {
        ObjectIntHashMap uniquePublicNames = new ObjectIntHashMap();
        ObjectIntHashMap uniqueInternalNames = new ObjectIntHashMap();
        IntHashSet uniqueIds = new IntHashSet();
        for (NamedToken token : tokens) {
            if (token.isInternal()) {
                this.checkNameUniqueness((MutableObjectIntMap<String>)uniqueInternalNames, token, registries);
                this.checkNameUniqueness(registries.internalNameToId, token, registries);
                uniqueInternalNames.put((Object)token.name(), token.id());
            } else {
                this.checkNameUniqueness((MutableObjectIntMap<String>)uniquePublicNames, token, registries);
                this.checkNameUniqueness(registries.publicNameToId, token, registries);
                uniquePublicNames.put((Object)token.name(), token.id());
            }
            if (!uniqueIds.add(token.id()) || registries.idToToken.containsKey(token.id())) {
                NamedToken existingToken = (NamedToken)registries.idToToken.get(token.id());
                throw new NonUniqueTokenException(this.tokenType, token, existingToken);
            }
            TokenRegistry.insertUnchecked(token, registries);
        }
        return registries;
    }

    private void checkNameUniqueness(MutableObjectIntMap<String> namesToId, NamedToken token, Registries registries) {
        if (namesToId.containsKey((Object)token.name())) {
            int existingKey = namesToId.get((Object)token.name());
            NamedToken existingToken = (NamedToken)registries.idToToken.get(existingKey);
            throw new NonUniqueTokenException(this.tokenType, token, existingToken);
        }
    }

    private static void insertUnchecked(NamedToken token, Registries registries) {
        registries.idToToken.put(token.id(), (Object)token);
        if (token.isInternal()) {
            registries.internalNameToId.put((Object)token.name(), token.id());
        } else {
            registries.publicNameToId.put((Object)token.name(), token.id());
        }
    }

    private static int getIdForName(MutableObjectIntMap<String> nameToId, String name) {
        return nameToId.getIfAbsent((Object)name, -1);
    }

    private static final class Registries {
        private final MutableObjectIntMap<String> publicNameToId;
        private final MutableObjectIntMap<String> internalNameToId;
        private final MutableIntObjectMap<NamedToken> idToToken;

        private Registries() {
            this((MutableObjectIntMap<String>)ObjectIntMaps.mutable.empty(), (MutableObjectIntMap<String>)ObjectIntMaps.mutable.empty(), (MutableIntObjectMap<NamedToken>)IntObjectMaps.mutable.empty());
        }

        private Registries(MutableObjectIntMap<String> publicNameToId, MutableObjectIntMap<String> internalNameToId, MutableIntObjectMap<NamedToken> idToToken) {
            this.publicNameToId = publicNameToId;
            this.internalNameToId = internalNameToId;
            this.idToToken = idToToken;
        }

        private Registries copy() {
            return new Registries((MutableObjectIntMap<String>)ObjectIntMaps.mutable.withAll(this.publicNameToId), (MutableObjectIntMap<String>)ObjectIntMaps.mutable.withAll(this.internalNameToId), (MutableIntObjectMap<NamedToken>)IntObjectMaps.mutable.withAll(this.idToToken));
        }
    }
}

