/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine;

import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final long transactionId;
    private final int transactionChecksum;
    private final long transactionCommitTimestamp;
    private final long transactionConsensusIndex;
    private final LogPosition logPosition;

    public ReadOnlyTransactionIdStore(LogTailMetadata logTailMetadata) {
        TransactionId lastCommittedTransaction = logTailMetadata.getLastCommittedTransaction();
        this.transactionId = lastCommittedTransaction.transactionId();
        this.transactionChecksum = lastCommittedTransaction.checksum();
        this.transactionCommitTimestamp = lastCommittedTransaction.commitTimestamp();
        this.logPosition = logTailMetadata.getLastTransactionLogPosition();
        this.transactionConsensusIndex = lastCommittedTransaction.consensusIndex();
    }

    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long committingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, long consensusIndex) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long getLastCommittedTransactionId() {
        return this.transactionId;
    }

    public TransactionId getLastCommittedTransaction() {
        return new TransactionId(this.transactionId, this.transactionChecksum, 0L, this.transactionConsensusIndex);
    }

    public long getLastClosedTransactionId() {
        return this.transactionId;
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return new TransactionIdSnapshot(this.transactionId);
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return new ClosedTransactionMetadata(this.transactionId, this.logPosition, this.transactionChecksum, this.transactionCommitTimestamp, this.transactionConsensusIndex);
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long consensusIndex, long logByteOffset, long logVersion) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionClosed(long transactionId, long logVersion, long logByteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }
}

