/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.util.concurrent.AsyncApply;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public class IdGeneratorUpdatesWorkSync {
    public static final String ID_GENERATOR_BATCH_APPLIER_TAG = "idGeneratorBatchApplier";
    private final Map<IdGenerator, WorkSync<IdGenerator, IdGeneratorUpdateWork>> workSyncMap = new HashMap<IdGenerator, WorkSync<IdGenerator, IdGeneratorUpdateWork>>();

    public void add(IdGenerator idGenerator) {
        this.workSyncMap.put(idGenerator, (WorkSync<IdGenerator, IdGeneratorUpdateWork>)new WorkSync((Object)idGenerator));
    }

    public Batch newBatch(CursorContextFactory contextFactory) {
        return new Batch(contextFactory);
    }

    public class Batch
    implements IdUpdateListener {
        private final Map<IdGenerator, ChangedIds> idUpdatesMap = new HashMap<IdGenerator, ChangedIds>();
        private final CursorContextFactory contextFactory;

        protected Batch(CursorContextFactory contextFactory) {
            this.contextFactory = contextFactory;
        }

        @Override
        public void markIdAsUsed(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
            this.idUpdatesMap.computeIfAbsent(idGenerator, t -> new ChangedIds()).addUsedId(id, size);
        }

        @Override
        public void markIdAsUnused(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
            this.idUpdatesMap.computeIfAbsent(idGenerator, t -> new ChangedIds()).addUnusedId(id, size);
        }

        public AsyncApply applyAsync() {
            if (this.idUpdatesMap.isEmpty()) {
                return AsyncApply.EMPTY;
            }
            this.applyInternal();
            return this::awaitApply;
        }

        public void apply() throws ExecutionException {
            if (!this.idUpdatesMap.isEmpty()) {
                this.applyInternal();
                this.awaitApply();
            }
        }

        private void awaitApply() throws ExecutionException {
            for (Map.Entry<IdGenerator, ChangedIds> idChanges : this.idUpdatesMap.entrySet()) {
                ChangedIds unit = idChanges.getValue();
                unit.awaitApply();
            }
        }

        private void applyInternal() {
            for (Map.Entry<IdGenerator, ChangedIds> idChanges : this.idUpdatesMap.entrySet()) {
                ChangedIds unit = idChanges.getValue();
                unit.applyAsync(IdGeneratorUpdatesWorkSync.this.workSyncMap.get(idChanges.getKey()), this.contextFactory);
            }
        }

        @Override
        public void close() throws Exception {
            this.apply();
        }
    }

    private static class IdGeneratorUpdateWork
    implements Work<IdGenerator, IdGeneratorUpdateWork> {
        private final List<ChangedIds> changeList = new ArrayList<ChangedIds>();
        private final CursorContextFactory contextFactory;

        IdGeneratorUpdateWork(ChangedIds changes, CursorContextFactory contextFactory) {
            this.contextFactory = contextFactory;
            this.changeList.add(changes);
        }

        public IdGeneratorUpdateWork combine(IdGeneratorUpdateWork work) {
            this.changeList.addAll(work.changeList);
            return this;
        }

        public void apply(IdGenerator idGenerator) {
            try (CursorContext cursorContext = this.contextFactory.create(IdGeneratorUpdatesWorkSync.ID_GENERATOR_BATCH_APPLIER_TAG);
                 IdGenerator.Marker marker = idGenerator.marker(cursorContext);){
                for (ChangedIds changes : this.changeList) {
                    changes.accept(marker);
                }
            }
        }
    }

    private static class ChangedIds {
        private final MutableLongList ids = LongLists.mutable.empty();
        private AsyncApply asyncApply;

        private ChangedIds() {
        }

        private void addUsedId(long id, int numberOfIds) {
            this.ids.add(IdUtils.combinedIdAndNumberOfIds((long)id, (int)numberOfIds, (boolean)true));
        }

        void addUnusedId(long id, int numberOfIds) {
            this.ids.add(IdUtils.combinedIdAndNumberOfIds((long)id, (int)numberOfIds, (boolean)false));
        }

        void accept(IdGenerator.Marker visitor) {
            this.ids.forEach((LongProcedure & Serializable)combined -> {
                long id = IdUtils.idFromCombinedId((long)combined);
                int slots = IdUtils.numberOfIdsFromCombinedId((long)combined);
                if (IdUtils.usedFromCombinedId((long)combined)) {
                    visitor.markUsed(id, slots);
                } else {
                    visitor.markDeleted(id, slots);
                }
            });
        }

        void applyAsync(WorkSync<IdGenerator, IdGeneratorUpdateWork> workSync, CursorContextFactory contextFactory) {
            this.asyncApply = workSync.applyAsync((Work)new IdGeneratorUpdateWork(this, contextFactory));
        }

        void awaitApply() throws ExecutionException {
            this.asyncApply.await();
        }
    }
}

