/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.collection.PrimitiveLongArrayQueue;
import org.neo4j.counts.CountsStorage;
import org.neo4j.counts.InvalidCountException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.SingleRoot;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsChanges;
import org.neo4j.internal.counts.CountsHeader;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.CountsLayout;
import org.neo4j.internal.counts.CountsValue;
import org.neo4j.internal.counts.DeltaTreeWriter;
import org.neo4j.internal.counts.MapCountsChanges;
import org.neo4j.internal.counts.MapWriter;
import org.neo4j.internal.counts.TreeWriter;
import org.neo4j.internal.counts.TxIdInformation;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public abstract class GBPTreeGenericCountsStore<T>
implements CountsStorage<T> {
    public static final Monitor NO_MONITOR = txId -> {};
    private static final long NEEDS_REBUILDING_HIGH_ID = 0L;
    private static final String OPEN_COUNT_STORE_TAG = "openCountStore";
    static final long INVALID_COUNT = -1L;
    protected final GBPTree<CountsKey, CountsValue> tree;
    private final OutOfOrderSequence idSequence;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    protected final CountsLayout layout = new CountsLayout();
    private final Rebuilder rebuilder;
    private final boolean needsRebuild;
    private final boolean readOnly;
    private final String name;
    private final Monitor monitor;
    private final String databaseName;
    private final int maxCacheSize;
    private final int highMarkCacheSize;
    protected volatile CountsChanges changes = this.createCountChanges();
    private final TxIdInformation txIdInformation;
    private final FileSystemAbstraction fileSystem;
    private final InternalLogProvider userLogProvider;
    private volatile boolean started;
    public static final Rebuilder EMPTY_REBUILD = new Rebuilder(){

        @Override
        public long lastCommittedTxId() {
            return 1L;
        }

        @Override
        public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GBPTreeGenericCountsStore(PageCache pageCache, Path file, FileSystemAbstraction fileSystem, RecoveryCleanupWorkCollector recoveryCollector, Rebuilder rebuilder, boolean readOnly, String name, Monitor monitor, String databaseName, int maxCacheSize, InternalLogProvider userLogProvider, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions) throws IOException {
        GBPTree<CountsKey, CountsValue> instantiatedTree;
        this.fileSystem = fileSystem;
        this.userLogProvider = userLogProvider;
        this.readOnly = readOnly;
        this.name = name;
        this.monitor = monitor;
        this.databaseName = databaseName;
        this.maxCacheSize = maxCacheSize;
        this.highMarkCacheSize = (int)((double)maxCacheSize * 0.8);
        this.rebuilder = rebuilder;
        CountsHeader.Reader headerReader = CountsHeader.reader();
        try {
            instantiatedTree = this.instantiateTree(pageCache, file, recoveryCollector, readOnly, headerReader, contextFactory, pageCacheTracer, openOptions);
        }
        catch (MetadataMismatchException e) {
            fileSystem.deleteFileOrThrow(file);
            headerReader = CountsHeader.reader();
            instantiatedTree = this.instantiateTree(pageCache, file, recoveryCollector, readOnly, headerReader, contextFactory, pageCacheTracer, openOptions);
        }
        this.tree = instantiatedTree;
        boolean successful = false;
        try {
            try (CursorContext cursorContext = contextFactory.create(OPEN_COUNT_STORE_TAG);){
                this.txIdInformation = this.readTxIdInformation(headerReader.highestGapFreeTxId(), cursorContext);
                this.idSequence = new ArrayQueueOutOfOrderSequence(this.txIdInformation.highestGapFreeTxId, 200, ArrayUtils.EMPTY_LONG_ARRAY);
                this.txIdInformation.strayTxIds.forEach((LongProcedure & Serializable)txId -> this.idSequence.offer(txId, ArrayUtils.EMPTY_LONG_ARRAY));
                this.needsRebuild = !headerReader.wasRead() || headerReader.highestGapFreeTxId() == 0L;
                successful = true;
            }
            if (successful) return;
        }
        catch (Throwable throwable) {
            if (successful) throw throwable;
            IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
            throw throwable;
        }
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
    }

    protected CountsChanges createCountChanges() {
        return new MapCountsChanges();
    }

    private GBPTree<CountsKey, CountsValue> instantiateTree(PageCache pageCache, Path file, RecoveryCleanupWorkCollector recoveryCollector, boolean readOnly, CountsHeader.Reader headerReader, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions) {
        try {
            return new GBPTree(pageCache, this.fileSystem, file, (Layout)this.layout, GBPTree.NO_MONITOR, (Header.Reader)headerReader, recoveryCollector, readOnly, openOptions.newWithout((Object)PageCacheOpenOptions.MULTI_VERSIONED), this.databaseName, this.name, contextFactory, pageCacheTracer);
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Counts store file could not be found, most likely this database needs to be recovered, file:" + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) throws IOException {
        if (this.needsRebuild || this.rebuilder.lastCommittedTxId() != this.idSequence.getHighestGapFreeNumber()) {
            Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (String)"Counts store needs rebuilding (most likely this database needs to be recovered), but is read-only.");
            try (CountUpdater updater = this.directUpdater(false, cursorContext);){
                this.rebuilder.rebuild(updater, cursorContext, memoryTracker);
            }
            finally {
                this.idSequence.set(this.rebuilder.lastCommittedTxId(), ArrayUtils.EMPTY_LONG_ARRAY);
            }
        }
        this.started = true;
    }

    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
    }

    protected CountUpdater updater(long txId, boolean isLast, CursorContext cursorContext) {
        boolean inRecoveryOnEmptyCountsStore;
        if (txId % 10L == 0L) {
            this.checkCacheSizeAndPotentiallyFlush(cursorContext);
        }
        Lock lock = GBPTreeGenericCountsStore.lock(this.lock.readLock());
        boolean alreadyApplied = this.txIdInformation.txIdIsAlreadyApplied(txId);
        boolean bl = inRecoveryOnEmptyCountsStore = this.needsRebuild && !this.started;
        if (alreadyApplied || inRecoveryOnEmptyCountsStore) {
            lock.unlock();
            this.monitor.ignoredTransaction(txId);
            return null;
        }
        return new CountUpdater(new MapWriter(key -> this.readCountFromTree((CountsKey)key, cursorContext), this.changes, this.idSequence, txId, isLast), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountUpdater directUpdater(boolean applyDeltas, CursorContext cursorContext) throws IOException {
        boolean success = false;
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            CountUpdater.CountWriter writer = applyDeltas ? new DeltaTreeWriter((ThrowingSupplier<Writer<CountsKey, CountsValue>, IOException>)((ThrowingSupplier)() -> this.tree.writer(1, cursorContext)), key -> this.readCountFromTree((CountsKey)key, cursorContext), (Comparator<CountsKey>)((Object)this.layout), this.maxCacheSize, this.userLogProvider) : new TreeWriter((Writer<CountsKey, CountsValue>)this.tree.writer(1, cursorContext), this.userLogProvider);
            CountUpdater updater = new CountUpdater(writer, lock);
            success = true;
            CountUpdater countUpdater = updater;
            return countUpdater;
        }
        finally {
            if (!success) {
                lock.unlock();
            }
        }
    }

    public void checkpoint(FileFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        if (this.readOnly) {
            return;
        }
        try (CriticalSection criticalSection = new CriticalSection(this.lock);){
            criticalSection.acquireExclusive();
            OutOfOrderSequence.Snapshot txIdSnapshot = this.idSequence.snapshot();
            this.writeChangesToTreeAndSwitchToSharedCriticalSection(criticalSection, cursorContext);
            this.updateTxIdInformationInTree(txIdSnapshot, cursorContext);
            this.tree.checkpoint((Consumer)CountsHeader.writer(txIdSnapshot.highestGapFree()[0]), flushEvent, cursorContext);
        }
    }

    private void checkCacheSizeAndPotentiallyFlush(CursorContext cursorContext) {
        block9: {
            int cacheSize = this.changes.size();
            if (cacheSize > this.highMarkCacheSize) {
                try (CriticalSection criticalSection = new CriticalSection(this.lock);){
                    if (!criticalSection.tryAcquireExclusive() && cacheSize > this.maxCacheSize) {
                        criticalSection.acquireExclusive();
                    }
                    if (!criticalSection.hasExclusive() || this.changes.size() <= this.maxCacheSize) break block9;
                    try {
                        this.writeChangesToTreeAndSwitchToSharedCriticalSection(criticalSection, cursorContext);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChangesToTreeAndSwitchToSharedCriticalSection(CriticalSection criticalSection, CursorContext cursorContext) throws IOException {
        CountsChanges changesToWrite;
        criticalSection.acquireShared();
        try {
            changesToWrite = this.changes;
            this.changes = this.changes.freezeAndFork();
        }
        finally {
            criticalSection.releaseExclusive();
        }
        this.writeCountsChanges(changesToWrite, cursorContext);
        this.changes.clearPreviousChanges();
    }

    private void writeCountsChanges(CountsChanges changes, CursorContext cursorContext) throws IOException {
        try (TreeWriter writer = new TreeWriter((Writer<CountsKey, CountsValue>)this.tree.writer(1, cursorContext), this.userLogProvider);){
            changes.sortedChanges((Comparator<CountsKey>)((Object)this.layout)).forEach(entry -> writer.write((CountsKey)entry.getKey(), ((AtomicLong)entry.getValue()).get()));
        }
    }

    private void updateTxIdInformationInTree(OutOfOrderSequence.Snapshot txIdSnapshot, CursorContext cursorContext) throws IOException {
        PrimitiveLongArrayQueue strayIds = new PrimitiveLongArrayQueue();
        this.visitStrayTxIdsInTree(arg_0 -> ((PrimitiveLongArrayQueue)strayIds).enqueue(arg_0), cursorContext);
        try (Writer writer = this.tree.writer(1, cursorContext);){
            long[][] strayTxIds;
            CountsValue value = new CountsValue();
            while (!strayIds.isEmpty()) {
                long strayTxId = strayIds.dequeue();
                writer.remove((Object)CountsKey.strayTxId(strayTxId));
            }
            value.initialize(0L);
            for (long[] strayTxId : strayTxIds = txIdSnapshot.idsOutOfOrder()) {
                long txId = strayTxId[0];
                writer.put((Object)CountsKey.strayTxId(txId), (Object)value);
            }
        }
    }

    public long txId() {
        return this.idSequence.getHighestGapFreeNumber();
    }

    protected long read(CountsKey key, CursorContext cursorContext) {
        long changedCount = this.changes.get(key);
        return changedCount != -1L ? changedCount : this.readCountFromTree(key, cursorContext);
    }

    public void visitAllCounts(CountVisitor visitor, CursorContext cursorContext) {
        for (Map.Entry<CountsKey, AtomicLong> changedEntry : this.changes.sortedChanges((Comparator<CountsKey>)((Object)this.layout))) {
            if (changedEntry.getValue().get() == 0L) continue;
            visitor.visit(changedEntry.getKey(), changedEntry.getValue().get());
        }
        try (Seeker seek = this.tree.seek((Object)CountsKey.MIN_COUNT, (Object)CountsKey.MAX_COUNT, cursorContext);){
            while (seek.next()) {
                CountsKey key = (CountsKey)seek.key();
                if (this.changes.containsChange(key)) continue;
                visitor.visit(key, ((CountsValue)seek.value()).count);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readCountFromTree(CountsKey key, CursorContext cursorContext) {
        try (Seeker seek = this.tree.seek((Object)key, (Object)key, cursorContext);){
            if (!seek.next()) {
                long l2 = 0L;
                return l2;
            }
            if (((CountsValue)seek.value()).count == -1L) {
                throw new InvalidCountException("The count value for key '" + key + "' is invalid. This is a serious error which is typically caused by a store corruption");
            }
            long l = ((CountsValue)seek.value()).count;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void visitStrayTxIdsInTree(LongConsumer visitor, CursorContext cursorContext) throws IOException {
        try (Seeker seek = this.tree.seek((Object)CountsKey.MIN_STRAY_TX_ID, (Object)CountsKey.MAX_STRAY_TX_ID, cursorContext);){
            while (seek.next()) {
                visitor.accept(((CountsKey)seek.key()).first);
            }
        }
    }

    private TxIdInformation readTxIdInformation(long highestGapFreeTxId, CursorContext cursorContext) throws IOException {
        LongHashSet strayTxIds = new LongHashSet();
        this.visitStrayTxIdsInTree(arg_0 -> ((MutableLongSet)strayTxIds).add(arg_0), cursorContext);
        return new TxIdInformation(highestGapFreeTxId, (LongSet)strayTxIds);
    }

    private static Lock lock(Lock lock) {
        lock.lock();
        return lock;
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class), contextFactory, numThreads);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor visitor, CursorContextFactory contextFactory, int numThreads) {
        try {
            return this.tree.consistencyCheck(visitor, contextFactory, numThreads);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected static void dump(PageCache pageCache, FileSystemAbstraction fileSystem, Path file, final PrintStream out, String databaseName, String name, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, final Function<CountsKey, String> keyToString, ImmutableSet<OpenOption> openOptions) throws IOException {
        CountsHeader.Reader headerReader = CountsHeader.reader();
        try (CursorContext cursorContext = contextFactory.create("dump");){
            GBPTree.readHeader((PageCache)pageCache, (Path)file, (Header.Reader)headerReader, (String)databaseName, (CursorContext)cursorContext, openOptions);
        }
        try (GBPTree tree = new GBPTree(pageCache, fileSystem, file, (Layout)new CountsLayout(), GBPTree.NO_MONITOR, (Header.Reader)headerReader, RecoveryCleanupWorkCollector.ignore(), true, openOptions.newWithout((Object)PageCacheOpenOptions.MULTI_VERSIONED), databaseName, name, contextFactory, pageCacheTracer);){
            out.printf("Highest gap-free txId: %d%n", headerReader.highestGapFreeTxId());
            try (CursorContext cursorContext = contextFactory.create("dumpVisitor");){
                tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<SingleRoot, CountsKey, CountsValue>(){
                    private CountsKey key;

                    public void key(CountsKey key, boolean isLeaf, long offloadId) {
                        this.key = key;
                    }

                    public void value(CountsValue value) {
                        out.printf("%s = %d%n", keyToString.apply(this.key), value.count);
                    }
                }, cursorContext);
            }
        }
    }

    @FunctionalInterface
    public static interface Monitor {
        public void ignoredTransaction(long var1);
    }

    public static interface Rebuilder {
        public long lastCommittedTxId();

        public void rebuild(CountUpdater var1, CursorContext var2, MemoryTracker var3);
    }

    private static class CriticalSection
    implements AutoCloseable {
        private final ReadWriteLock lock;
        private boolean exclusive;
        private boolean shared;

        private CriticalSection(ReadWriteLock lock) {
            this.lock = lock;
        }

        boolean tryAcquireExclusive() {
            assert (!this.exclusive && !this.shared);
            this.exclusive = this.lock.writeLock().tryLock();
            return this.exclusive;
        }

        void acquireExclusive() {
            assert (!this.exclusive && !this.shared);
            this.lock.writeLock().lock();
            this.exclusive = true;
        }

        void acquireShared() {
            assert (this.exclusive && !this.shared);
            this.lock.readLock().lock();
            this.shared = true;
        }

        void releaseExclusive() {
            assert (this.exclusive);
            this.lock.writeLock().unlock();
            this.exclusive = false;
        }

        @Override
        public void close() {
            if (this.shared) {
                this.lock.readLock().unlock();
                this.shared = false;
            }
            if (this.exclusive) {
                this.lock.writeLock().unlock();
                this.exclusive = false;
            }
        }

        boolean hasExclusive() {
            return this.exclusive;
        }
    }

    public static interface CountVisitor {
        public void visit(CountsKey var1, long var2);
    }
}

