/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine;

import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.storageengine.api.ClosedBatchMetadata;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.OpenTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final LogPosition logPosition;
    private final TransactionId lastCommittedTransaction;
    private final AppendBatchInfo lastBatch;

    public ReadOnlyTransactionIdStore(LogTailLogVersionsMetadata logTailMetadata) {
        this.lastCommittedTransaction = logTailMetadata.getLastCommittedTransaction();
        this.logPosition = logTailMetadata.getLastTransactionLogPosition();
        this.lastBatch = logTailMetadata.lastBatch();
    }

    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionCommitted(long transactionId, long appendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long getLastCommittedTransactionId() {
        return this.lastCommittedTransaction.id();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.lastCommittedTransaction;
    }

    public long getLastClosedTransactionId() {
        return this.lastCommittedTransaction.id();
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return new TransactionIdSnapshot(this.getLastClosedTransactionId());
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return new ClosedTransactionMetadata(this.lastCommittedTransaction, this.logPosition);
    }

    public ClosedBatchMetadata getLastClosedBatch() {
        return new ClosedBatchMetadata(this.lastBatch.appendIndex(), this.lastCommittedTransaction.kernelVersion(), this.logPosition);
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, long transactionAppendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex, long logByteOffset, long logVersion, long appendIndex) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionClosed(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long logByteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void batchClosed(long transactionId, long appendIndex, boolean firstBatch, boolean lastBatch, KernelVersion kernelVersion, LogPosition logPositionAfter) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void resetLastClosedTransaction(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void appendBatch(long transactionId, long appendIndex, boolean firstBatch, boolean lastBatch, LogPosition logPositionBefore, LogPosition logPositionAfter) {
    }

    public AppendBatchInfo getLastCommittedBatch() {
        return this.lastBatch;
    }

    public OpenTransactionMetadata getOldestOpenTransaction() {
        return null;
    }

    public TransactionId getHighestEverClosedTransaction() {
        return this.lastCommittedTransaction;
    }
}

