/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.function.Function;

public class CountsKey {
    static final int SIZE = 13;
    private static final byte TYPE_STRAY_TX_ID = 0;
    static final CountsKey MIN_COUNT = new CountsKey(1, Long.MIN_VALUE, Integer.MIN_VALUE);
    static final CountsKey MAX_COUNT = new CountsKey(127, Long.MAX_VALUE, Integer.MAX_VALUE);
    static final CountsKey MIN_STRAY_TX_ID = CountsKey.strayTxId(Long.MIN_VALUE);
    static final CountsKey MAX_STRAY_TX_ID = CountsKey.strayTxId(Long.MAX_VALUE);
    byte type;
    long first;
    int second;

    CountsKey() {
    }

    public CountsKey(byte type, long keyFirst, int keySecond) {
        this.initialize(type, keyFirst, keySecond);
    }

    public void initialize(byte type, long keyFirst, int keySecond) {
        this.type = type;
        this.first = keyFirst;
        this.second = keySecond;
    }

    static CountsKey strayTxId(long txId) {
        return new CountsKey(0, txId, 0);
    }

    int extractHighFirstInt() {
        return (int)(this.first >>> 32);
    }

    int extractLowFirstInt() {
        return (int)this.first;
    }

    public long first() {
        return this.first;
    }

    public int second() {
        return this.second;
    }

    public int type() {
        return this.type;
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + (int)(this.first ^ this.first >>> 32);
        result = 31 * result + this.second;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CountsKey)) {
            return false;
        }
        CountsKey other = (CountsKey)obj;
        return this.type == other.type && this.first == other.first && this.second == other.second;
    }

    public String toString() {
        return this.toString(key -> String.format("CountsKey[type:%d, first:%d, second:%d]", key.type, key.first, key.second));
    }

    String toString(Function<CountsKey, String> customTypeToString) {
        if (this.type == 0) {
            return String.format("Stray tx id:%d", this.first);
        }
        return customTypeToString.apply(this);
    }
}

