/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.concurrent.locks.Lock;
import org.neo4j.counts.InvalidCountException;
import org.neo4j.internal.counts.CountsKey;

public class CountUpdater
implements AutoCloseable {
    private final CountWriter writer;
    private final Lock lock;

    CountUpdater(CountWriter writer, Lock lock) {
        this.writer = writer;
        this.lock = lock;
    }

    public boolean increment(CountsKey key, long delta) {
        try {
            return this.writer.write(key, delta);
        }
        catch (InvalidCountException e) {
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    static interface CountWriter
    extends AutoCloseable {
        public boolean write(CountsKey var1, long var2);

        @Override
        public void close();
    }
}

