/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import org.neo4j.internal.id.IdGenerator;
import org.neo4j.io.pagecache.context.CursorContext;

public interface IdUpdateListener
extends AutoCloseable {
    public static final IdUpdateListener DIRECT = new IdUpdateListener(){

        @Override
        public void close() {
        }

        @Override
        public void markIdAsUsed(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
            try (IdGenerator.TransactionalMarker marker = idGenerator.transactionalMarker(cursorContext);){
                marker.markUsed(id, size);
            }
        }

        @Override
        public void markIdAsUnused(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
            try (IdGenerator.TransactionalMarker marker = idGenerator.transactionalMarker(cursorContext);){
                marker.markDeleted(id, size);
            }
        }
    };
    public static final IdUpdateListener DIRECT_WITH_FREE_ON_DELETE = new IdUpdateListener(){

        @Override
        public void close() {
        }

        @Override
        public void markIdAsUsed(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
            try (IdGenerator.TransactionalMarker marker = idGenerator.transactionalMarker(cursorContext);){
                marker.markUsed(id, size);
            }
        }

        @Override
        public void markIdAsUnused(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
            try (IdGenerator.TransactionalMarker marker = idGenerator.transactionalMarker(cursorContext);){
                marker.markDeletedAndFree(id, size);
            }
        }
    };
    public static final IdUpdateListener IGNORE = new IdUpdateListener(){

        @Override
        public void close() {
        }

        @Override
        public void markIdAsUsed(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
        }

        @Override
        public void markIdAsUnused(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
        }
    };

    public void markIdAsUsed(IdGenerator var1, long var2, int var4, CursorContext var5);

    public void markIdAsUnused(IdGenerator var1, long var2, int var4, CursorContext var5);

    default public void markId(IdGenerator idGenerator, long id, int size, boolean used, CursorContext cursorContext) {
        if (used) {
            this.markIdAsUsed(idGenerator, id, size, cursorContext);
        } else {
            this.markIdAsUnused(idGenerator, id, size, cursorContext);
        }
    }
}

