/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.TransactionId;

public class HighestTransactionId {
    private final AtomicReference<TransactionId> highest = new AtomicReference();

    public HighestTransactionId(TransactionId transactionId) {
        this.highest.set(transactionId);
    }

    public boolean offer(long transactionId, long appendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex) {
        TransactionId high = this.highest.getAcquire();
        if (transactionId < high.id()) {
            return false;
        }
        TransactionId update = new TransactionId(transactionId, appendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
        while (!this.highest.weakCompareAndSetVolatile(high, update)) {
            high = this.highest.getAcquire();
            if (high.id() < transactionId) continue;
            return false;
        }
        return true;
    }

    public final void set(long transactionId, long appendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex) {
        this.highest.set(new TransactionId(transactionId, appendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex));
    }

    public TransactionId get() {
        return this.highest.get();
    }
}

