/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine;

import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.storageengine.api.LogVersionRepository;

public class ReadOnlyLogVersionRepository
implements LogVersionRepository {
    private final FixedLogVersion logVersion;
    private final FixedLogVersion checkpointLogVersion;

    public ReadOnlyLogVersionRepository(LogTailMetadata logTailMetadata) {
        this.logVersion = new FixedLogVersion(logTailMetadata.getLogVersion());
        this.checkpointLogVersion = new FixedLogVersion(logTailMetadata.getCheckpointLogVersion());
    }

    public long getCurrentLogVersion() {
        return ReadOnlyLogVersionRepository.getCurrentVersion(this.logVersion);
    }

    public void setCurrentLogVersion(long version) {
        ReadOnlyLogVersionRepository.setCurrentVersionAttempt();
    }

    public long incrementAndGetVersion() {
        return ReadOnlyLogVersionRepository.incrementAndGetVersion(this.logVersion);
    }

    public long getCheckpointLogVersion() {
        return ReadOnlyLogVersionRepository.getCurrentVersion(this.checkpointLogVersion);
    }

    public void setCheckpointLogVersion(long version) {
        ReadOnlyLogVersionRepository.setCurrentVersionAttempt();
    }

    public long incrementAndGetCheckpointLogVersion() {
        return ReadOnlyLogVersionRepository.incrementAndGetVersion(this.checkpointLogVersion);
    }

    private static long getCurrentVersion(FixedLogVersion version) {
        if (version.isIncrementAttempted()) {
            throw new IllegalStateException("Read-only log version repository has observed a call to incrementVersion, which indicates that it's been shut down");
        }
        return version.getValue();
    }

    private static void setCurrentVersionAttempt() {
        throw new UnsupportedOperationException("Can't set current log version in read only version repository.");
    }

    private static long incrementAndGetVersion(FixedLogVersion version) {
        if (version.isIncrementAttempted()) {
            throw new IllegalStateException("Read-only log version repository only allows to call incrementVersion once, during shutdown");
        }
        version.setIncrementAttempt();
        return version.getValue();
    }

    private static class FixedLogVersion {
        private boolean incrementAttempt;
        private final long value;

        FixedLogVersion(long value) {
            this.value = value;
        }

        boolean isIncrementAttempted() {
            return this.incrementAttempt;
        }

        long getValue() {
            return this.value;
        }

        void setIncrementAttempt() {
            this.incrementAttempt = true;
        }
    }
}

