/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorImplementation;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SchemaRuleMapifier {
    private static final String PROP_SCHEMA_RULE_PREFIX = "__org.neo4j.SchemaRule.";
    private static final String PROP_SCHEMA_RULE_TYPE = "__org.neo4j.SchemaRule.schemaRuleType";
    private static final String PROP_INDEX_RULE_TYPE = "__org.neo4j.SchemaRule.indexRuleType";
    private static final String PROP_CONSTRAINT_RULE_TYPE = "__org.neo4j.SchemaRule.constraintRuleType";
    private static final String PROP_SCHEMA_RULE_NAME = "__org.neo4j.SchemaRule.name";
    private static final String PROP_OWNED_INDEX = "__org.neo4j.SchemaRule.ownedIndex";
    public static final String PROP_OWNING_CONSTRAINT = "__org.neo4j.SchemaRule.owningConstraint";
    private static final String PROP_INDEX_PROVIDER_NAME = "__org.neo4j.SchemaRule.indexProviderName";
    private static final String PROP_INDEX_PROVIDER_VERSION = "__org.neo4j.SchemaRule.indexProviderVersion";
    private static final String PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE = "__org.neo4j.SchemaRule.schemaEntityType";
    private static final String PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS = "__org.neo4j.SchemaRule.schemaEntityIds";
    private static final String PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS = "__org.neo4j.SchemaRule.schemaPropertyIds";
    private static final String PROP_SCHEMA_DESCRIPTOR_PROPERTY_SCHEMA_TYPE = "__org.neo4j.SchemaRule.schemaPropertySchemaType";
    private static final String PROP_INDEX_TYPE = "__org.neo4j.SchemaRule.indexType";
    private static final String PROP_INDEX_CONFIG_PREFIX = "__org.neo4j.SchemaRule.IndexConfig.";

    public static Map<String, Value> mapifySchemaRule(SchemaRule rule) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_RULE_NAME, rule.getName());
        SchemaRuleMapifier.schemaDescriptorToMap(rule.schema(), map);
        if (rule instanceof IndexDescriptor) {
            SchemaRuleMapifier.schemaIndexToMap((IndexDescriptor)rule, map);
        } else if (rule instanceof ConstraintDescriptor) {
            SchemaRuleMapifier.schemaConstraintToMap((ConstraintDescriptor)rule, map);
        }
        return map;
    }

    public static SchemaRule unmapifySchemaRule(long ruleId, Map<String, Value> map) throws MalformedSchemaRuleException {
        String schemaRuleType;
        switch (schemaRuleType = SchemaRuleMapifier.getString(PROP_SCHEMA_RULE_TYPE, map)) {
            case "INDEX": {
                return SchemaRuleMapifier.buildIndexRule(ruleId, map);
            }
            case "CONSTRAINT": {
                return SchemaRuleMapifier.buildConstraintRule(ruleId, map);
            }
        }
        throw new MalformedSchemaRuleException("Can not create a schema rule of type: " + schemaRuleType);
    }

    private static void schemaDescriptorToMap(SchemaDescriptor schemaDescriptor, Map<String, Value> map) {
        EntityType entityType = schemaDescriptor.entityType();
        PropertySchemaType propertySchemaType = schemaDescriptor.propertySchemaType();
        int[] entityTokenIds = schemaDescriptor.getEntityTokenIds();
        int[] propertyIds = schemaDescriptor.getPropertyIds();
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE, entityType.name());
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_DESCRIPTOR_PROPERTY_SCHEMA_TYPE, propertySchemaType.name());
        SchemaRuleMapifier.putIntArrayProperty(map, PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS, entityTokenIds);
        SchemaRuleMapifier.putIntArrayProperty(map, PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS, propertyIds);
    }

    private static void indexConfigToMap(IndexConfig indexConfig, Map<String, Value> map) {
        RichIterable entries = indexConfig.entries();
        for (Pair entry : entries) {
            SchemaRuleMapifier.putIndexConfigProperty(map, (String)entry.getOne(), (Value)entry.getTwo());
        }
    }

    private static void schemaIndexToMap(IndexDescriptor rule, Map<String, Value> map) {
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_RULE_TYPE, "INDEX");
        IndexType indexType = rule.getIndexType();
        SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_TYPE, indexType.name());
        if (rule.isUnique()) {
            SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_RULE_TYPE, "UNIQUE");
            if (rule.getOwningConstraintId().isPresent()) {
                map.put(PROP_OWNING_CONSTRAINT, (Value)Values.longValue((long)rule.getOwningConstraintId().getAsLong()));
            }
        } else {
            SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_RULE_TYPE, "NON_UNIQUE");
        }
        SchemaRuleMapifier.indexProviderToMap(rule, map);
        IndexConfig indexConfig = rule.getIndexConfig();
        SchemaRuleMapifier.indexConfigToMap(indexConfig, map);
    }

    private static void indexProviderToMap(IndexDescriptor rule, Map<String, Value> map) {
        IndexProviderDescriptor provider = rule.getIndexProvider();
        String name = provider.getKey();
        String version = provider.getVersion();
        SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_PROVIDER_NAME, name);
        SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_PROVIDER_VERSION, version);
    }

    private static void schemaConstraintToMap(ConstraintDescriptor rule, Map<String, Value> map) {
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_RULE_TYPE, "CONSTRAINT");
        ConstraintType type = rule.type();
        switch (type) {
            case UNIQUE: {
                SchemaRuleMapifier.putStringProperty(map, PROP_CONSTRAINT_RULE_TYPE, "UNIQUE");
                SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_TYPE, rule.asIndexBackedConstraint().indexType().name());
                if (!rule.asIndexBackedConstraint().hasOwnedIndexId()) break;
                SchemaRuleMapifier.putLongProperty(map, PROP_OWNED_INDEX, rule.asIndexBackedConstraint().ownedIndexId());
                break;
            }
            case EXISTS: {
                SchemaRuleMapifier.putStringProperty(map, PROP_CONSTRAINT_RULE_TYPE, "EXISTS");
                break;
            }
            case UNIQUE_EXISTS: {
                SchemaRuleMapifier.putStringProperty(map, PROP_CONSTRAINT_RULE_TYPE, "UNIQUE_EXISTS");
                SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_TYPE, rule.asIndexBackedConstraint().indexType().name());
                if (!rule.asIndexBackedConstraint().hasOwnedIndexId()) break;
                SchemaRuleMapifier.putLongProperty(map, PROP_OWNED_INDEX, rule.asIndexBackedConstraint().ownedIndexId());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized constraint type: " + type);
            }
        }
    }

    private static int[] getIntArray(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof IntArray) {
            return (int[])value.asObject();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a IntArray but was " + value);
    }

    private static long getLong(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof LongValue) {
            return ((LongValue)value).value();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a LongValue but was " + value);
    }

    private static OptionalLong getOptionalLong(String property, Map<String, Value> props) {
        Value value = props.get(property);
        if (value instanceof LongValue) {
            return OptionalLong.of(((LongValue)value).value());
        }
        return OptionalLong.empty();
    }

    private static String getString(String property, Map<String, Value> map) throws MalformedSchemaRuleException {
        Value value = map.get(property);
        if (value instanceof TextValue) {
            return ((TextValue)value).stringValue();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a TextValue but was " + value);
    }

    private static Optional<String> getOptionalString(String property, Map<String, Value> map) {
        Value value = map.get(property);
        if (value instanceof TextValue) {
            return Optional.of(((TextValue)value).stringValue());
        }
        return Optional.empty();
    }

    private static void putLongProperty(Map<String, Value> map, String property, long value) {
        map.put(property, (Value)Values.longValue((long)value));
    }

    private static void putIntArrayProperty(Map<String, Value> map, String property, int[] value) {
        map.put(property, (Value)Values.intArray((int[])value));
    }

    private static void putStringProperty(Map<String, Value> map, String property, String value) {
        map.put(property, (Value)Values.stringValue((String)value));
    }

    private static void putIndexConfigProperty(Map<String, Value> map, String key, Value value) {
        map.put(PROP_INDEX_CONFIG_PREFIX + key, value);
    }

    private static SchemaRule buildIndexRule(long schemaRuleId, Map<String, Value> props) throws MalformedSchemaRuleException {
        SchemaDescriptor schema = SchemaRuleMapifier.buildSchemaDescriptor(props);
        String indexRuleType = SchemaRuleMapifier.getString(PROP_INDEX_RULE_TYPE, props);
        boolean unique = SchemaRuleMapifier.parseIndexType(indexRuleType);
        IndexPrototype prototype = unique ? IndexPrototype.uniqueForSchema((SchemaDescriptor)schema) : IndexPrototype.forSchema((SchemaDescriptor)schema);
        prototype = prototype.withName(SchemaRuleMapifier.getString(PROP_SCHEMA_RULE_NAME, props));
        prototype = prototype.withIndexType(SchemaRuleMapifier.getIndexType(SchemaRuleMapifier.getString(PROP_INDEX_TYPE, props)));
        String providerKey = SchemaRuleMapifier.getString(PROP_INDEX_PROVIDER_NAME, props);
        String providerVersion = SchemaRuleMapifier.getString(PROP_INDEX_PROVIDER_VERSION, props);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(providerKey, providerVersion);
        prototype = prototype.withIndexProvider(providerDescriptor);
        IndexDescriptor index = prototype.materialise(schemaRuleId);
        IndexConfig indexConfig = SchemaRuleMapifier.extractIndexConfig(props);
        index = index.withIndexConfig(indexConfig);
        if (props.containsKey(PROP_OWNING_CONSTRAINT)) {
            index = index.withOwningConstraintId(SchemaRuleMapifier.getLong(PROP_OWNING_CONSTRAINT, props));
        }
        return index;
    }

    private static boolean parseIndexType(String indexRuleType) throws MalformedSchemaRuleException {
        switch (indexRuleType) {
            case "NON_UNIQUE": {
                return false;
            }
            case "UNIQUE": {
                return true;
            }
        }
        throw new MalformedSchemaRuleException("Did not recognize index rule type: " + indexRuleType);
    }

    private static SchemaRule buildConstraintRule(long id, Map<String, Value> props) throws MalformedSchemaRuleException {
        SchemaDescriptor schema = SchemaRuleMapifier.buildSchemaDescriptor(props);
        String constraintRuleType = SchemaRuleMapifier.getString(PROP_CONSTRAINT_RULE_TYPE, props);
        String name = SchemaRuleMapifier.getString(PROP_SCHEMA_RULE_NAME, props);
        OptionalLong ownedIndex = SchemaRuleMapifier.getOptionalLong(PROP_OWNED_INDEX, props);
        Optional<String> indexTypeString = SchemaRuleMapifier.getOptionalString(PROP_INDEX_TYPE, props);
        switch (constraintRuleType) {
            case "UNIQUE": {
                UniquenessConstraintDescriptor constraint;
                UniquenessConstraintDescriptor uniquenessConstraintDescriptor = constraint = indexTypeString.isPresent() ? ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, (IndexType)SchemaRuleMapifier.getIndexType(indexTypeString.get())) : ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
                if (ownedIndex.isPresent()) {
                    constraint = constraint.withOwnedIndexId(ownedIndex.getAsLong());
                }
                return constraint.withId(id).withName(name);
            }
            case "EXISTS": {
                ConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)schema);
                return constraint.withId(id).withName(name);
            }
            case "UNIQUE_EXISTS": {
                NodeKeyConstraintDescriptor constraint;
                NodeKeyConstraintDescriptor nodeKeyConstraintDescriptor = constraint = indexTypeString.isPresent() ? ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)schema, (IndexType)SchemaRuleMapifier.getIndexType(indexTypeString.get())) : ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)schema);
                if (ownedIndex.isPresent()) {
                    constraint = constraint.withOwnedIndexId(ownedIndex.getAsLong());
                }
                return constraint.withId(id).withName(name);
            }
        }
        throw new MalformedSchemaRuleException("Did not recognize constraint rule type: " + constraintRuleType);
    }

    private static SchemaDescriptor buildSchemaDescriptor(Map<String, Value> props) throws MalformedSchemaRuleException {
        EntityType entityType = SchemaRuleMapifier.getEntityType(SchemaRuleMapifier.getString(PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE, props));
        PropertySchemaType propertySchemaType = SchemaRuleMapifier.getPropertySchemaType(SchemaRuleMapifier.getString(PROP_SCHEMA_DESCRIPTOR_PROPERTY_SCHEMA_TYPE, props));
        int[] entityIds = SchemaRuleMapifier.getIntArray(PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS, props);
        int[] propertyIds = SchemaRuleMapifier.getIntArray(PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS, props);
        return new SchemaDescriptorImplementation(entityType, propertySchemaType, entityIds, propertyIds);
    }

    private static IndexConfig extractIndexConfig(Map<String, Value> props) {
        HashMap<String, Value> configMap = new HashMap<String, Value>();
        for (Map.Entry<String, Value> entry : props.entrySet()) {
            if (!entry.getKey().startsWith(PROP_INDEX_CONFIG_PREFIX)) continue;
            configMap.put(entry.getKey().substring(PROP_INDEX_CONFIG_PREFIX.length()), entry.getValue());
        }
        return IndexConfig.with(configMap);
    }

    private static IndexType getIndexType(String indexType) throws MalformedSchemaRuleException {
        try {
            return IndexType.valueOf((String)indexType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize index type: " + indexType, (Throwable)e);
        }
    }

    private static PropertySchemaType getPropertySchemaType(String propertySchemaType) throws MalformedSchemaRuleException {
        try {
            return PropertySchemaType.valueOf((String)propertySchemaType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize property schema type: " + propertySchemaType, (Throwable)e);
        }
    }

    private static EntityType getEntityType(String entityType) throws MalformedSchemaRuleException {
        try {
            return EntityType.valueOf((String)entityType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize entity type: " + entityType, (Throwable)e);
        }
    }
}

