/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.helpers.collection.NestingIterator;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.util.concurrent.AsyncApply;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public class IndexUpdatesWorkSync {
    private final WorkSync<IndexUpdateListener, IndexUpdatesWork> workSync;

    public IndexUpdatesWorkSync(IndexUpdateListener listener) {
        this.workSync = new WorkSync((Object)listener);
    }

    public Batch newBatch() {
        return new Batch();
    }

    private static class IndexUpdatesWork
    implements Work<IndexUpdateListener, IndexUpdatesWork> {
        private final List<Iterable<IndexEntryUpdate<IndexDescriptor>>> updates;
        private final CursorContext cursorContext;

        IndexUpdatesWork(List<Iterable<IndexEntryUpdate<IndexDescriptor>>> updates, CursorContext cursorContext) {
            this.cursorContext = cursorContext;
            this.updates = updates;
        }

        public IndexUpdatesWork combine(IndexUpdatesWork work) {
            this.updates.addAll(work.updates);
            return this;
        }

        public void apply(IndexUpdateListener material) {
            try {
                material.applyUpdates(this.combinedUpdates(), this.cursorContext);
            }
            catch (IOException | KernelException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        private Iterable<IndexEntryUpdate<IndexDescriptor>> combinedUpdates() {
            return () -> new NestingIterator<IndexEntryUpdate<IndexDescriptor>, Iterable<IndexEntryUpdate<IndexDescriptor>>>(this.updates.iterator()){

                protected Iterator<IndexEntryUpdate<IndexDescriptor>> createNestedIterator(Iterable<IndexEntryUpdate<IndexDescriptor>> item) {
                    return item.iterator();
                }
            };
        }
    }

    public class Batch {
        private final List<Iterable<IndexEntryUpdate<IndexDescriptor>>> updates = new ArrayList<Iterable<IndexEntryUpdate<IndexDescriptor>>>();
        private List<IndexEntryUpdate<IndexDescriptor>> singleUpdates;

        public void add(Iterable<IndexEntryUpdate<IndexDescriptor>> indexUpdates) {
            this.updates.add(indexUpdates);
        }

        public void add(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
            if (this.singleUpdates == null) {
                this.singleUpdates = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
            }
            this.singleUpdates.add(indexUpdate);
        }

        private void addSingleUpdates() {
            if (this.singleUpdates != null) {
                this.updates.add(this.singleUpdates);
            }
        }

        public void apply(CursorContext cursorContext) throws ExecutionException {
            this.addSingleUpdates();
            if (!this.updates.isEmpty()) {
                IndexUpdatesWorkSync.this.workSync.apply((Work)new IndexUpdatesWork(this.updates, cursorContext));
            }
        }

        public AsyncApply applyAsync(CursorContext cursorContext) {
            this.addSingleUpdates();
            return this.updates.isEmpty() ? AsyncApply.EMPTY : IndexUpdatesWorkSync.this.workSync.applyAsync((Work)new IndexUpdatesWork(this.updates, cursorContext));
        }
    }
}

