/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.util.Preconditions;

class CountsChanges {
    static final long ABSENT = -1L;
    private final ConcurrentHashMap<CountsKey, AtomicLong> changes = new ConcurrentHashMap();
    private volatile ConcurrentHashMap<CountsKey, AtomicLong> previousChanges;
    private volatile boolean frozen;

    CountsChanges() {
    }

    private CountsChanges(ConcurrentHashMap<CountsKey, AtomicLong> previousChanges) {
        this.previousChanges = previousChanges;
    }

    CountsChanges freezeAndFork() {
        this.frozen = true;
        return new CountsChanges(this.changes);
    }

    void clearPreviousChanges() {
        this.previousChanges = null;
    }

    void add(CountsKey key, long delta, Function<CountsKey, AtomicLong> defaultToStoredCount) {
        Preconditions.checkState((!this.frozen ? 1 : 0) != 0, (String)"Can't make changes in a frozen state");
        this.getCounter(key, defaultToStoredCount).addAndGet(delta);
    }

    private AtomicLong getCounter(CountsKey key, Function<CountsKey, AtomicLong> defaultToStoredCount) {
        ConcurrentHashMap<CountsKey, AtomicLong> prev = this.previousChanges;
        Function<CountsKey, AtomicLong> defaultFunction = prev == null ? defaultToStoredCount : k -> {
            AtomicLong prevCount = (AtomicLong)prev.get(k);
            if (prevCount != null) {
                return new AtomicLong(prevCount.get());
            }
            return (AtomicLong)defaultToStoredCount.apply((CountsKey)k);
        };
        return this.changes.computeIfAbsent(key, defaultFunction);
    }

    Iterable<Map.Entry<CountsKey, AtomicLong>> sortedChanges(Comparator<CountsKey> comparator) {
        ArrayList<Map.Entry<CountsKey, AtomicLong>> sortedChanges = new ArrayList<Map.Entry<CountsKey, AtomicLong>>(this.changes.entrySet());
        sortedChanges.sort((e1, e2) -> comparator.compare((CountsKey)e1.getKey(), (CountsKey)e2.getKey()));
        return sortedChanges;
    }

    boolean containsChange(CountsKey key) {
        if (this.changes.containsKey(key)) {
            return true;
        }
        ConcurrentHashMap<CountsKey, AtomicLong> prev = this.previousChanges;
        return prev != null && prev.containsKey(key);
    }

    long get(CountsKey key) {
        AtomicLong prevCount;
        AtomicLong count = this.changes.get(key);
        if (count != null) {
            return count.get();
        }
        ConcurrentHashMap<CountsKey, AtomicLong> prev = this.previousChanges;
        if (prev != null && (prevCount = prev.get(key)) != null) {
            return prevCount.get();
        }
        return -1L;
    }

    int size() {
        return this.changes.size();
    }
}

