/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.io.Serializable;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.graphdb.Direction;
import org.neo4j.storageengine.api.Degrees;

public class EagerDegrees
implements Degrees,
Degrees.Mutator {
    private static final int FIRST_TYPE_UNDECIDED = -1;
    private int firstType = -1;
    private Degree firstTypeDegrees;
    private MutableIntObjectMap<Degree> degrees;

    @Override
    public boolean add(int type, int outgoing, int incoming, int loop) {
        this.getOrCreateDegree(type).add(outgoing, incoming, loop);
        return true;
    }

    public void addOutgoing(int type, int count) {
        this.getOrCreateDegree((int)type).outgoing += count;
    }

    public void addIncoming(int type, int count) {
        this.getOrCreateDegree((int)type).incoming += count;
    }

    public void addLoop(int type, int count) {
        this.getOrCreateDegree((int)type).loop += count;
    }

    private Degree getOrCreateDegree(int type) {
        if (this.firstType == -1) {
            this.firstType = type;
            this.firstTypeDegrees = new Degree();
            return this.firstTypeDegrees;
        }
        if (this.firstType == type) {
            return this.firstTypeDegrees;
        }
        if (this.degrees == null) {
            this.degrees = IntObjectMaps.mutable.empty();
        }
        return (Degree)this.degrees.getIfAbsentPut(type, (Function0 & Serializable)() -> new Degree());
    }

    @Override
    public int[] types() {
        if (this.firstType == -1) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        if (this.degrees == null) {
            return new int[]{this.firstType};
        }
        int[] types = new int[this.degrees.size() + 1];
        types[0] = this.firstType;
        System.arraycopy(this.degrees.keySet().toArray(), 0, types, 1, this.degrees.size());
        return types;
    }

    @Override
    public int degree(int type, Direction direction) {
        Degree degree = null;
        if (this.firstType == type) {
            degree = this.firstTypeDegrees;
        } else if (this.degrees != null) {
            degree = (Degree)this.degrees.get(type);
        }
        if (degree == null) {
            return 0;
        }
        switch (direction) {
            case OUTGOING: {
                return degree.outgoing + degree.loop;
            }
            case INCOMING: {
                return degree.incoming + degree.loop;
            }
            case BOTH: {
                return degree.outgoing + degree.incoming + degree.loop;
            }
        }
        throw new IllegalArgumentException("Unrecognized direction " + direction);
    }

    @Override
    public boolean isSplit() {
        return true;
    }

    private static class Degree {
        private int outgoing;
        private int incoming;
        private int loop;

        private Degree() {
        }

        void add(int outgoing, int incoming, int loop) {
            this.outgoing += outgoing;
            this.incoming += incoming;
            this.loop += loop;
        }
    }
}

