/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Rm
extends TransactionProvidingApp {
    public Rm() {
        this.addOptionDefinition("p", new OptionDefinition(OptionValueType.NONE, "Removes a property"));
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.MUST, "Removes one or more labels"));
    }

    @Override
    public String getDescription() {
        return "Removes a property from the current node or relationship or label from the current node.\nUsage:\n  rm <key>\n  rm -p name\n  rm -l PERSON";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws Exception {
        NodeOrRelationship thing = this.getCurrent(session);
        boolean forProperty = parser.options().containsKey("p");
        boolean forLabel = parser.options().containsKey("l");
        if (forProperty || !forLabel) {
            if (parser.arguments().isEmpty()) {
                throw new ShellException("Must supply the property key or label name to remove, like: rm title");
            }
            String key = parser.arguments().get(0);
            if (thing.removeProperty(key) == null) {
                out.println((Serializable)((Object)("Property '" + key + "' not found")));
            }
        } else {
            Node node = thing.asNode();
            for (Label label : this.parseLabels(parser)) {
                node.removeLabel(label);
            }
        }
        return Continuation.INPUT_COMPLETE;
    }
}

