/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.neo4j.shell.impl.HostBoundSocketFactory;

public class RmiLocation {
    private final String host;
    private final int port;
    private final String name;
    private Registry registry;

    private RmiLocation(String host, int port, String name) {
        this.host = host;
        this.port = port;
        this.name = name;
    }

    public static RmiLocation location(String host, int port, String name) {
        return new RmiLocation(host, port, name);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    private static String getProtocol() {
        return "rmi://";
    }

    public String toShortUrl() {
        return RmiLocation.getProtocol() + this.getHost() + ":" + this.getPort();
    }

    public String toUrl() {
        return RmiLocation.getProtocol() + this.getHost() + ":" + this.getPort() + "/" + this.getName();
    }

    public Registry ensureRegistryCreated() throws RemoteException {
        try {
            Naming.list(this.toShortUrl());
            return LocateRegistry.getRegistry(this.getHost(), this.getPort());
        }
        catch (RemoteException e) {
            try {
                return LocateRegistry.createRegistry(this.getPort(), null, new HostBoundSocketFactory(this.host));
            }
            catch (UnknownHostException hostException) {
                throw new RemoteException("Unable to bind to '" + this.host + "', unknown hostname.", hostException);
            }
        }
        catch (MalformedURLException e) {
            throw new RemoteException("Malformed URL", e);
        }
    }

    public void bind(Remote object) throws RemoteException {
        this.registry = this.ensureRegistryCreated();
        try {
            Naming.rebind(this.toUrl(), object);
        }
        catch (MalformedURLException e) {
            throw new RemoteException("Malformed URL", e);
        }
    }

    public void unbind() throws RemoteException {
        UnicastRemoteObject.unexportObject(this.registry, true);
    }

    public boolean isBound() {
        try {
            this.getBoundObject();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public Remote getBoundObject() throws RemoteException {
        try {
            return Naming.lookup(this.toUrl());
        }
        catch (NoSuchObjectException | NotBoundException e) {
            throw new RemoteException("Not bound", e);
        }
        catch (MalformedURLException e) {
            throw new RemoteException("Malformed URL", e);
        }
    }
}

