/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shell.Session;

public class SessionImpl
implements Session {
    private static final long serialVersionUID = 1L;
    private final Map<String, Serializable> properties = new HashMap<String, Serializable>();
    final SessionWriter writer = this.initializeWriter(this.properties);

    protected SessionWriter initializeWriter(final Map<String, Serializable> properties) {
        return new SessionWriter(){

            @Override
            public void set(String key, Serializable value) throws RemoteException {
                SessionImpl.setProperty(properties, key, value);
            }
        };
    }

    @Override
    public void set(String key, Serializable value) {
        try {
            if (this.writer != null) {
                this.writer.set(key, value);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        SessionImpl.setProperty(this.properties, key, value);
    }

    protected static void setProperty(Map<String, Serializable> properties, String key, Serializable value) {
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }

    @Override
    public Serializable get(String key) {
        return this.properties.get(key);
    }

    @Override
    public Serializable remove(String key) {
        return this.properties.remove(key);
    }

    @Override
    public String[] keys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public Map<String, Serializable> asMap() {
        return new HashMap<String, Serializable>(this.properties);
    }

    static interface SessionWriter
    extends Remote {
        public void set(String var1, Serializable var2) throws RemoteException;
    }
}

