/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.TabCompletion;
import org.neo4j.shell.impl.RemotelyAvailableServer;

public abstract class AbstractServer
implements ShellServer {
    private ShellServer remoteEndPoint;
    public static final String DEFAULT_NAME = "shell";
    public static final int DEFAULT_PORT = 1337;
    private Map<String, Serializable> properties = new HashMap<String, Serializable>();

    @Override
    public String getName() {
        return DEFAULT_NAME;
    }

    @Override
    public Serializable getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Serializable value) {
        this.properties.put(key, value);
    }

    @Override
    public Serializable interpretVariable(String key, Serializable value, Session session) throws ShellException, RemoteException {
        return session.get(key);
    }

    @Override
    public String welcome() {
        return "Welcome to the shell";
    }

    @Override
    public synchronized void shutdown() throws RemoteException {
        if (this.remoteEndPoint != null) {
            this.remoteEndPoint.shutdown();
            this.remoteEndPoint = null;
        }
    }

    @Override
    public synchronized void makeRemotelyAvailable(int port, String name) throws RemoteException {
        if (this.remoteEndPoint == null) {
            this.remoteEndPoint = new RemotelyAvailableServer(this);
        }
        this.remoteEndPoint.makeRemotelyAvailable(port, name);
    }

    @Override
    public String[] getAllAvailableCommands() {
        return new String[0];
    }

    @Override
    public TabCompletion tabComplete(String partOfLine, Session session) throws ShellException, RemoteException {
        return new TabCompletion(Collections.<String>emptyList(), 0);
    }
}

