/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.server.security.systemgraph.ComponentVersion;

public abstract class KnownSystemComponentVersion {
    private final Label versionLabel = Label.label((String)"Version");
    private final ComponentVersion componentVersion;
    protected final String componentVersionProperty;
    public final int version;
    public final String description;
    protected final Log log;

    protected KnownSystemComponentVersion(ComponentVersion componentVersion, Log log) {
        this.componentVersion = componentVersion;
        this.componentVersionProperty = componentVersion.getComponentName();
        this.version = componentVersion.getVersion();
        this.description = componentVersion.getDescription();
        this.log = log;
    }

    public boolean isCurrent() {
        return this.componentVersion.isCurrent();
    }

    public boolean migrationSupported() {
        return this.componentVersion.migrationSupported();
    }

    public boolean runtimeSupported() {
        return this.componentVersion.runtimeSupported();
    }

    protected int getVersion(Transaction tx) {
        Node versionNode;
        int result = -1;
        ResourceIterator nodes = tx.findNodes(this.versionLabel);
        if (nodes.hasNext() && (versionNode = (Node)nodes.next()).hasProperty(this.componentVersionProperty)) {
            result = (Integer)versionNode.getProperty(this.componentVersionProperty);
        }
        nodes.close();
        return result;
    }

    public boolean detected(Transaction tx) {
        return this.getVersion(tx) == this.version;
    }

    public UnsupportedOperationException unsupported() {
        String message = String.format("System graph version %d for component '%s' in '%s' is not supported", this.version, this.componentVersionProperty, this.description);
        this.log.error(message);
        return new UnsupportedOperationException(message);
    }

    public SystemGraphComponent.Status getStatus() {
        if (this.version == -1) {
            return SystemGraphComponent.Status.UNINITIALIZED;
        }
        if (this.isCurrent()) {
            return SystemGraphComponent.Status.CURRENT;
        }
        if (this.migrationSupported()) {
            return this.runtimeSupported() ? SystemGraphComponent.Status.REQUIRES_UPGRADE : SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE;
        }
        return SystemGraphComponent.Status.UNSUPPORTED;
    }

    protected static boolean nodesWithLabelExist(Transaction tx, Label label) {
        boolean result = false;
        ResourceIterator nodes = tx.findNodes(label);
        if (nodes.hasNext()) {
            result = true;
        }
        nodes.close();
        return result;
    }

    public void setVersionProperty(Transaction tx, int newVersion) {
        Node versionNode = this.findOrCreateVersionNode(tx);
        if (versionNode.hasProperty(this.componentVersionProperty)) {
            int oldVersion = (Integer)versionNode.getProperty(this.componentVersionProperty);
            this.log.info(String.format("Upgrading '%s' version property from %d to %d", this.componentVersionProperty, oldVersion, newVersion));
        } else {
            this.log.info(String.format("Setting version for '%s' to %d", this.componentVersionProperty, newVersion));
        }
        versionNode.setProperty(this.componentVersionProperty, (Object)newVersion);
    }

    private Node findOrCreateVersionNode(Transaction tx) {
        ResourceIterator nodes = tx.findNodes(this.versionLabel);
        if (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            if (nodes.hasNext()) {
                throw new IllegalStateException("More than one Version node exists");
            }
            return node;
        }
        return tx.createNode(new Label[]{this.versionLabel});
    }
}

