/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.neo4j.cypher.internal.security.FormatException;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicLoginContext;
import org.neo4j.server.security.auth.ShiroAuthToken;
import org.neo4j.server.security.systemgraph.SecurityGraphInitializer;
import org.neo4j.server.security.systemgraph.SystemGraphAuthenticationInfo;

public class BasicSystemGraphRealm
extends AuthorizingRealm
implements AuthManager,
CredentialsMatcher {
    private final SecurityGraphInitializer systemGraphInitializer;
    private final DatabaseManager<?> databaseManager;
    private final SecureHasher secureHasher;
    private final AuthenticationStrategy authenticationStrategy;
    private final boolean authenticationEnabled;
    public static final String IS_SUSPENDED = "is_suspended";
    private static final Pattern usernamePattern = Pattern.compile("^[\\x21-\\x2B\\x2D-\\x39\\x3B-\\x7E]+$");

    public BasicSystemGraphRealm(SecurityGraphInitializer systemGraphInitializer, DatabaseManager<?> databaseManager, SecureHasher secureHasher, AuthenticationStrategy authenticationStrategy, boolean authenticationEnabled) {
        this.systemGraphInitializer = systemGraphInitializer;
        this.databaseManager = databaseManager;
        this.secureHasher = secureHasher;
        this.authenticationStrategy = authenticationStrategy;
        this.authenticationEnabled = authenticationEnabled;
        this.setAuthenticationCachingEnabled(true);
        this.setCredentialsMatcher(this);
    }

    public void start() throws Exception {
        this.systemGraphInitializer.initializeSecurityGraph();
    }

    public void stop() {
    }

    public void shutdown() {
    }

    public boolean supports(AuthenticationToken token) {
        try {
            if (token instanceof ShiroAuthToken) {
                ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
                return shiroAuthToken.getScheme().equals("basic") && shiroAuthToken.supportsRealm("native");
            }
            return false;
        }
        catch (InvalidAuthTokenException e) {
            return false;
        }
    }

    public AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        User user;
        String username;
        if (!this.authenticationEnabled) {
            return null;
        }
        ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
        try {
            username = AuthToken.safeCast((String)"principal", shiroAuthToken.getAuthTokenMap());
            AuthToken.safeCastCredentials((String)"credentials", shiroAuthToken.getAuthTokenMap());
        }
        catch (InvalidAuthTokenException e) {
            throw new UnsupportedTokenException((Throwable)e);
        }
        try {
            user = this.getUser(username);
        }
        catch (FormatException | InvalidArgumentsException e) {
            throw new UnknownAccountException();
        }
        return new SystemGraphAuthenticationInfo(user, this.getName());
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        byte[] password;
        SystemGraphAuthenticationInfo ourInfo = (SystemGraphAuthenticationInfo)info;
        User user = ourInfo.getUserRecord();
        try {
            ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
            password = AuthToken.safeCastCredentials((String)"credentials", shiroAuthToken.getAuthTokenMap());
        }
        catch (InvalidAuthTokenException e) {
            throw new UnsupportedTokenException((Throwable)e);
        }
        AuthenticationResult result = this.authenticationStrategy.authenticate(user, password);
        switch (result) {
            case SUCCESS: {
                break;
            }
            case PASSWORD_CHANGE_REQUIRED: {
                break;
            }
            case FAILURE: {
                throw new IncorrectCredentialsException();
            }
            case TOO_MANY_ATTEMPTS: {
                throw new ExcessiveAttemptsException();
            }
            default: {
                throw new AuthenticationException();
            }
        }
        if (user.hasFlag(IS_SUSPENDED)) {
            throw new DisabledAccountException("User '" + user.name() + "' is suspended.");
        }
        if (user.passwordChangeRequired()) {
            result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
        }
        ourInfo.setAuthenticationResult(result);
        return true;
    }

    protected Object getAuthenticationCacheKey(AuthenticationToken token) {
        Object principal = token != null ? token.getPrincipal() : null;
        return principal != null ? principal : "";
    }

    protected Object getAuthenticationCacheKey(PrincipalCollection principals) {
        Object principal = this.getAvailablePrincipal(principals);
        return principal == null ? "" : principal;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }

    public User getUser(String username) throws InvalidArgumentsException, FormatException {
        User user;
        block9: {
            InvalidArgumentsException userDontExists = new InvalidArgumentsException("User '" + username + "' does not exist.");
            Transaction tx = this.getSystemDb().beginTx();
            try {
                Node userNode = tx.findNode(Label.label((String)"User"), "name", (Object)username);
                if (userNode == null) {
                    throw userDontExists;
                }
                SystemGraphCredential credential = SystemGraphCredential.deserialize((String)((String)userNode.getProperty("credentials")), (SecureHasher)this.secureHasher);
                boolean requirePasswordChange = (Boolean)userNode.getProperty("passwordChangeRequired");
                boolean suspended = (Boolean)userNode.getProperty("suspended");
                tx.commit();
                User.Builder builder = new User.Builder(username, (Credential)credential).withRequiredPasswordChange(requirePasswordChange);
                builder = suspended ? builder.withFlag(IS_SUSPENDED) : builder.withoutFlag(IS_SUSPENDED);
                user = builder.build();
                if (tx == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NotFoundException n) {
                    throw userDontExists;
                }
            }
            tx.close();
        }
        return user;
    }

    public static void assertValidUsername(String username) throws InvalidArgumentsException {
        if (username == null || username.isEmpty()) {
            throw new InvalidArgumentsException("The provided username is empty.");
        }
        if (!usernamePattern.matcher(username).matches()) {
            throw new InvalidArgumentsException("Username '" + username + "' contains illegal characters. Use ascii characters that are not ',', ':' or whitespaces.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginContext login(Map<String, Object> authToken) throws InvalidAuthTokenException {
        try {
            this.assertValidScheme(authToken);
            String username = AuthToken.safeCast((String)"principal", authToken);
            byte[] password = AuthToken.safeCastCredentials((String)"credentials", authToken);
            try {
                User user = this.getUser(username);
                AuthenticationResult result = this.authenticationStrategy.authenticate(user, password);
                if (result == AuthenticationResult.SUCCESS && user.passwordChangeRequired()) {
                    result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
                }
                BasicLoginContext basicLoginContext = new BasicLoginContext(user, result);
                return basicLoginContext;
            }
            catch (FormatException | InvalidArgumentsException e) {
                BasicLoginContext basicLoginContext = new BasicLoginContext(null, AuthenticationResult.FAILURE);
                AuthToken.clearCredentials(authToken);
                return basicLoginContext;
            }
        }
        finally {
            AuthToken.clearCredentials(authToken);
        }
    }

    public void log(String message, SecurityContext securityContext) {
    }

    private void assertValidScheme(Map<String, Object> token) throws InvalidAuthTokenException {
        String scheme = AuthToken.safeCast((String)"scheme", token);
        if (scheme.equals("none")) {
            throw AuthToken.invalidToken((String)", scheme 'none' is only allowed when auth is disabled.");
        }
        if (!scheme.equals("basic")) {
            throw AuthToken.invalidToken((String)(", scheme '" + scheme + "' is not supported."));
        }
    }

    protected GraphDatabaseService getSystemDb() {
        return ((DatabaseContext)this.databaseManager.getDatabaseContext(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new AuthProviderFailedException("No database called `system` was found."))).databaseFacade();
    }
}

