/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.File;
import java.nio.file.Path;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.server.security.auth.AuthProcedures;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.systemgraph.BasicSystemGraphRealm;
import org.neo4j.server.security.systemgraph.UserSecurityGraphInitializer;
import org.neo4j.time.Clocks;

public class CommunitySecurityModule
extends SecurityModule {
    private final LogProvider logProvider;
    private final Config config;
    private final GlobalProcedures globalProcedures;
    private final FileSystemAbstraction fileSystem;
    private final DependencySatisfier dependencySatisfier;
    private BasicSystemGraphRealm authManager;
    private SystemGraphInitializer systemGraphInitializer;
    private DatabaseManager<?> databaseManager;
    public static final String USER_STORE_FILENAME = "auth";
    public static final String INITIAL_USER_STORE_FILENAME = "auth.ini";

    public CommunitySecurityModule(LogService logService, Config config, GlobalProcedures procedures, FileSystemAbstraction fileSystem, DependencySatisfier dependencySatisfier) {
        this.logProvider = logService.getUserLogProvider();
        this.config = config;
        this.globalProcedures = procedures;
        this.fileSystem = fileSystem;
        this.dependencySatisfier = dependencySatisfier;
    }

    public void setup() {
        Dependencies platformDependencies = (Dependencies)this.dependencySatisfier;
        this.databaseManager = (DatabaseManager)platformDependencies.resolveDependency(DatabaseManager.class);
        this.systemGraphInitializer = (SystemGraphInitializer)platformDependencies.resolveDependency(SystemGraphInitializer.class);
        this.authManager = this.createBasicSystemGraphRealm(this.config, this.logProvider, this.fileSystem);
        this.life.add((Lifecycle)((BasicSystemGraphRealm)((Object)this.dependencySatisfier.satisfyDependency((Object)this.authManager))));
        this.registerProcedure(this.globalProcedures, this.logProvider.getLog(((Object)((Object)this)).getClass()), AuthProcedures.class, null);
    }

    public AuthManager authManager() {
        return this.authManager;
    }

    public static FileUserRepository getUserRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        return new FileUserRepository(fileSystem, CommunitySecurityModule.getUserRepositoryFile(config), logProvider);
    }

    public static FileUserRepository getInitialUserRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        return new FileUserRepository(fileSystem, CommunitySecurityModule.getInitialUserRepositoryFile(config), logProvider);
    }

    public static File getUserRepositoryFile(Config config) {
        return CommunitySecurityModule.getUserRepositoryFile(config, USER_STORE_FILENAME);
    }

    public static File getInitialUserRepositoryFile(Config config) {
        return CommunitySecurityModule.getUserRepositoryFile(config, INITIAL_USER_STORE_FILENAME);
    }

    private static File getUserRepositoryFile(Config config, String fileName) {
        File authStore = ((Path)config.get(GraphDatabaseSettings.auth_store)).toFile();
        if (authStore.isFile()) {
            return authStore;
        }
        File authStoreDir = ((Path)config.get(DatabaseManagementSystemSettings.auth_store_directory)).toFile();
        return new File(authStoreDir, fileName);
    }

    private BasicSystemGraphRealm createBasicSystemGraphRealm(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        SecureHasher secureHasher = new SecureHasher();
        FileUserRepository migrationUserRepository = CommunitySecurityModule.getUserRepository(config, logProvider, fileSystem);
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository(config, logProvider, fileSystem);
        UserSecurityGraphInitializer securityGraphInitializer = new UserSecurityGraphInitializer(this.databaseManager, this.systemGraphInitializer, logProvider.getLog(((Object)((Object)this)).getClass()), migrationUserRepository, initialUserRepository, secureHasher);
        return new BasicSystemGraphRealm(securityGraphInitializer, this.databaseManager, secureHasher, CommunitySecurityModule.createAuthenticationStrategy(config), true);
    }

    public static AuthenticationStrategy createAuthenticationStrategy(Config config) {
        return new RateLimitedAuthenticationStrategy(Clocks.systemClock(), config);
    }
}

